// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.waiters

import aws.sdk.kotlin.services.rds.RdsClient
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterSnapshotsRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterSnapshotsResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbClustersRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbClustersResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbInstancesRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbInstancesResponse
import aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsRequest
import aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotsResponse
import aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesRequest
import aws.sdk.kotlin.services.rds.model.DescribeTenantDatabasesResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import aws.smithy.kotlin.runtime.util.length
import kotlin.time.Duration.Companion.milliseconds


public suspend fun RdsClient.waitUntilDBClusterAvailable(request: DescribeDbClustersRequest = DescribeDbClustersRequest { }): Outcome<DescribeDbClustersResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbClustersRequest, DescribeDbClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusters(request) }
}

public suspend fun RdsClient.waitUntilDBClusterAvailable(block: DescribeDbClustersRequest.Builder.() -> Unit): Outcome<DescribeDbClustersResponse> =
    waitUntilDBClusterAvailable(DescribeDbClustersRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterDeleted(request: DescribeDbClustersRequest = DescribeDbClustersRequest { }): Outcome<DescribeDbClustersResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbClustersRequest, DescribeDbClustersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusters = it.dbClusters
            val length = dbClusters?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBClusterNotFoundFault"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusters = it.dbClusters
            val dbClustersOrEmpty = dbClusters?.flattenIfPossible()
            val projection = dbClustersOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusters(request) }
}

public suspend fun RdsClient.waitUntilDBClusterDeleted(block: DescribeDbClustersRequest.Builder.() -> Unit): Outcome<DescribeDbClustersResponse> =
    waitUntilDBClusterDeleted(DescribeDbClustersRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterSnapshotAvailable(request: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest { }): Outcome<DescribeDbClusterSnapshotsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusterSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBClusterSnapshotAvailable(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbClusterSnapshotsResponse> =
    waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBClusterSnapshotDeleted(request: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest { }): Outcome<DescribeDbClusterSnapshotsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbClusterSnapshotsRequest, DescribeDbClusterSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val length = dbClusterSnapshots?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBClusterSnapshotNotFoundFault"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbClusterSnapshots = it.dbClusterSnapshots
            val dbClusterSnapshotsOrEmpty = dbClusterSnapshots?.flattenIfPossible()
            val projection = dbClusterSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbClusterSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBClusterSnapshotDeleted(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbClusterSnapshotsResponse> =
    waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBInstanceAvailable(request: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): Outcome<DescribeDbInstancesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun RdsClient.waitUntilDBInstanceAvailable(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceAvailable(DescribeDbInstancesRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBInstanceDeleted(request: DescribeDbInstancesRequest = DescribeDbInstancesRequest { }): Outcome<DescribeDbInstancesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbInstancesRequest, DescribeDbInstancesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbInstances = it.dbInstances
            val length = dbInstances?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBInstanceNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbInstances = it.dbInstances
            val dbInstancesOrEmpty = dbInstances?.flattenIfPossible()
            val projection = dbInstancesOrEmpty?.flatMap {
                val dbInstanceStatus = it?.dbInstanceStatus
                listOfNotNull(dbInstanceStatus)
            }
            (projection as List<String?>?)?.any { it == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbInstances(request) }
}

public suspend fun RdsClient.waitUntilDBInstanceDeleted(block: DescribeDbInstancesRequest.Builder.() -> Unit): Outcome<DescribeDbInstancesResponse> =
    waitUntilDBInstanceDeleted(DescribeDbInstancesRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBSnapshotAvailable(request: DescribeDbSnapshotsRequest = DescribeDbSnapshotsRequest { }): Outcome<DescribeDbSnapshotsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "failed" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBSnapshotAvailable(block: DescribeDbSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbSnapshotsResponse> =
    waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilDBSnapshotDeleted(request: DescribeDbSnapshotsRequest = DescribeDbSnapshotsRequest { }): Outcome<DescribeDbSnapshotsResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeDbSnapshotsRequest, DescribeDbSnapshotsResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val dbSnapshots = it.dbSnapshots
            val length = dbSnapshots?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBSnapshotNotFound"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "creating" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "modifying" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "rebooting" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val dbSnapshots = it.dbSnapshots
            val dbSnapshotsOrEmpty = dbSnapshots?.flattenIfPossible()
            val projection = dbSnapshotsOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "resetting-master-credentials" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeDbSnapshots(request) }
}

public suspend fun RdsClient.waitUntilDBSnapshotDeleted(block: DescribeDbSnapshotsRequest.Builder.() -> Unit): Outcome<DescribeDbSnapshotsResponse> =
    waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilTenantDatabaseAvailable(request: DescribeTenantDatabasesRequest = DescribeTenantDatabasesRequest { }): Outcome<DescribeTenantDatabasesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTenantDatabasesRequest, DescribeTenantDatabasesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val tenantDatabases = it.tenantDatabases
            val tenantDatabasesOrEmpty = tenantDatabases?.flattenIfPossible()
            val projection = tenantDatabasesOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "available" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val tenantDatabases = it.tenantDatabases
            val tenantDatabasesOrEmpty = tenantDatabases?.flattenIfPossible()
            val projection = tenantDatabasesOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "deleted" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val tenantDatabases = it.tenantDatabases
            val tenantDatabasesOrEmpty = tenantDatabases?.flattenIfPossible()
            val projection = tenantDatabasesOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-parameters" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val tenantDatabases = it.tenantDatabases
            val tenantDatabasesOrEmpty = tenantDatabases?.flattenIfPossible()
            val projection = tenantDatabasesOrEmpty?.flatMap {
                val status = it?.status
                listOfNotNull(status)
            }
            (projection as List<String?>?)?.any { it == "incompatible-restore" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTenantDatabases(request) }
}

public suspend fun RdsClient.waitUntilTenantDatabaseAvailable(block: DescribeTenantDatabasesRequest.Builder.() -> Unit): Outcome<DescribeTenantDatabasesResponse> =
    waitUntilTenantDatabaseAvailable(DescribeTenantDatabasesRequest.Builder().apply(block).build())

public suspend fun RdsClient.waitUntilTenantDatabaseDeleted(request: DescribeTenantDatabasesRequest = DescribeTenantDatabasesRequest { }): Outcome<DescribeTenantDatabasesResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTenantDatabasesRequest, DescribeTenantDatabasesResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val tenantDatabases = it.tenantDatabases
            val length = tenantDatabases?.length ?: 0
            val number = 0.0
            val comparison = if (length == null) null else length.compareTo(number) == 0
            comparison == true
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "DBInstanceNotFoundFault"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTenantDatabases(request) }
}

public suspend fun RdsClient.waitUntilTenantDatabaseDeleted(block: DescribeTenantDatabasesRequest.Builder.() -> Unit): Outcome<DescribeTenantDatabasesResponse> =
    waitUntilTenantDatabaseDeleted(DescribeTenantDatabasesRequest.Builder().apply(block).build())
