// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StartActivityStreamResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class StartActivityStreamOperationDeserializer: HttpDeserialize<StartActivityStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartActivityStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartActivityStreamError(context, call)
        }
        val builder = StartActivityStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartActivityStreamOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartActivityStreamError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartActivityStreamOperationBody(builder: StartActivityStreamResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("StartActivityStreamResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("StartActivityStreamResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap StartActivityStream response")
    }
    // end unwrap response wrapper

    val APPLYIMMEDIATELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("ApplyImmediately"))
    val ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("EngineNativeAuditFieldsIncluded"))
    val KINESISSTREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("KinesisStreamName"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("KmsKeyId"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Mode"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("StartActivityStreamResult"))
        field(APPLYIMMEDIATELY_DESCRIPTOR)
        field(ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR)
        field(KINESISSTREAMNAME_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLYIMMEDIATELY_DESCRIPTOR.index -> builder.applyImmediately = deserializeBoolean()
                ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR.index -> builder.engineNativeAuditFieldsIncluded = deserializeBoolean()
                KINESISSTREAMNAME_DESCRIPTOR.index -> builder.kinesisStreamName = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                MODE_DESCRIPTOR.index -> builder.mode = deserializeString().let { ActivityStreamMode.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ActivityStreamStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
