// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ModifyDbShardGroupResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyDBShardGroupOperationDeserializer: HttpDeserialize<ModifyDbShardGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbShardGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbShardGroupError(context, call)
        }
        val builder = ModifyDbShardGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBShardGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbShardGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBShardGroupNotFound" -> DbShardGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "DBShardGroupAlreadyExists" -> DbShardGroupAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidMaxAcu" -> InvalidMaxAcuFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBShardGroupOperationBody(builder: ModifyDbShardGroupResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyDBShardGroupResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyDBShardGroupResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyDBShardGroup response")
    }
    // end unwrap response wrapper

    val COMPUTEREDUNDANCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("ComputeRedundancy"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterIdentifier"))
    val DBSHARDGROUPIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBShardGroupIdentifier"))
    val DBSHARDGROUPRESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBShardGroupResourceId"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Endpoint"))
    val MAXACU_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, XmlSerialName("MaxACU"))
    val PUBLICLYACCESSIBLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("PubliclyAccessible"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("ModifyDBShardGroupResult"))
        field(COMPUTEREDUNDANCY_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(DBSHARDGROUPIDENTIFIER_DESCRIPTOR)
        field(DBSHARDGROUPRESOURCEID_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(MAXACU_DESCRIPTOR)
        field(PUBLICLYACCESSIBLE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMPUTEREDUNDANCY_DESCRIPTOR.index -> builder.computeRedundancy = deserializeInt()
                DBCLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterIdentifier = deserializeString()
                DBSHARDGROUPIDENTIFIER_DESCRIPTOR.index -> builder.dbShardGroupIdentifier = deserializeString()
                DBSHARDGROUPRESOURCEID_DESCRIPTOR.index -> builder.dbShardGroupResourceId = deserializeString()
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                MAXACU_DESCRIPTOR.index -> builder.maxAcu = deserializeDouble()
                PUBLICLYACCESSIBLE_DESCRIPTOR.index -> builder.publiclyAccessible = deserializeBoolean()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
