// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.ModifyDbClusterEndpointResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ModifyDBClusterEndpointOperationDeserializer: HttpDeserialize<ModifyDbClusterEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ModifyDbClusterEndpointResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyDbClusterEndpointError(context, call)
        }
        val builder = ModifyDbClusterEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyDBClusterEndpointOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwModifyDbClusterEndpointError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBClusterEndpointNotFoundFault" -> DbClusterEndpointNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBClusterEndpointStateFault" -> InvalidDbClusterEndpointStateFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyDBClusterEndpointOperationBody(builder: ModifyDbClusterEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyDBClusterEndpointResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyDBClusterEndpointResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyDBClusterEndpoint response")
    }
    // end unwrap response wrapper

    val CUSTOMENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("CustomEndpointType"))
    val DBCLUSTERENDPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointArn"))
    val DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointIdentifier"))
    val DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterEndpointResourceIdentifier"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterIdentifier"))
    val ENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Endpoint"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("EndpointType"))
    val EXCLUDEDMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ExcludedMembers"))
    val STATICMEMBERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("StaticMembers"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("ModifyDBClusterEndpointResult"))
        field(CUSTOMENDPOINTTYPE_DESCRIPTOR)
        field(DBCLUSTERENDPOINTARN_DESCRIPTOR)
        field(DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR)
        field(DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(ENDPOINT_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(EXCLUDEDMEMBERS_DESCRIPTOR)
        field(STATICMEMBERS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CUSTOMENDPOINTTYPE_DESCRIPTOR.index -> builder.customEndpointType = deserializeString()
                DBCLUSTERENDPOINTARN_DESCRIPTOR.index -> builder.dbClusterEndpointArn = deserializeString()
                DBCLUSTERENDPOINTIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterEndpointIdentifier = deserializeString()
                DBCLUSTERENDPOINTRESOURCEIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterEndpointResourceIdentifier = deserializeString()
                DBCLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterIdentifier = deserializeString()
                ENDPOINT_DESCRIPTOR.index -> builder.endpoint = deserializeString()
                ENDPOINTTYPE_DESCRIPTOR.index -> builder.endpointType = deserializeString()
                EXCLUDEDMEMBERS_DESCRIPTOR.index -> builder.excludedMembers =
                    deserializer.deserializeList(EXCLUDEDMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATICMEMBERS_DESCRIPTOR.index -> builder.staticMembers =
                    deserializer.deserializeList(STATICMEMBERS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
