// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DeregisterDbProxyTargetsResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeregisterDBProxyTargetsOperationDeserializer: HttpDeserialize<DeregisterDbProxyTargetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeregisterDbProxyTargetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterDbProxyTargetsError(context, call)
        }
        val builder = DeregisterDbProxyTargetsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeregisterDbProxyTargetsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyTargetGroupNotFoundFault" -> DbProxyTargetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "DBProxyTargetNotFoundFault" -> DbProxyTargetNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        "InvalidDBProxyStateFault" -> InvalidDbProxyStateFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
