// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.serde

import aws.sdk.kotlin.services.rds.model.DeleteOptionGroupResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteOptionGroupOperationDeserializer: HttpDeserialize<DeleteOptionGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteOptionGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteOptionGroupError(context, call)
        }
        val builder = DeleteOptionGroupResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteOptionGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidOptionGroupStateFault" -> InvalidOptionGroupStateFaultDeserializer().deserialize(context, wrappedCall)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
