// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A tenant database in the DB instance. This data type is an element in the response to the `DescribeTenantDatabases` action.
 */
public class TenantDatabase private constructor(builder: Builder) {
    /**
     * The character set of the tenant database.
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * The ID of the DB instance that contains the tenant database.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the DB instance.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * Specifies whether deletion protection is enabled for the DB instance.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The master username of the tenant database.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The `NCHAR` character set name of the tenant database.
     */
    public val ncharCharacterSetName: kotlin.String? = builder.ncharCharacterSetName
    /**
     * Information about pending changes for a tenant database.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.rds.model.TenantDatabasePendingModifiedValues? = builder.pendingModifiedValues
    /**
     * The status of the tenant database.
     */
    public val status: kotlin.String? = builder.status
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The Amazon Resource Name (ARN) for the tenant database.
     */
    public val tenantDatabaseArn: kotlin.String? = builder.tenantDatabaseArn
    /**
     * The creation time of the tenant database.
     */
    public val tenantDatabaseCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.tenantDatabaseCreateTime
    /**
     * The Amazon Web Services Region-unique, immutable identifier for the tenant database.
     */
    public val tenantDatabaseResourceId: kotlin.String? = builder.tenantDatabaseResourceId
    /**
     * The database name of the tenant database.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.TenantDatabase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TenantDatabase(")
        append("characterSetName=$characterSetName,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("deletionProtection=$deletionProtection,")
        append("masterUsername=$masterUsername,")
        append("ncharCharacterSetName=$ncharCharacterSetName,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("status=$status,")
        append("tagList=$tagList,")
        append("tenantDatabaseArn=$tenantDatabaseArn,")
        append("tenantDatabaseCreateTime=$tenantDatabaseCreateTime,")
        append("tenantDatabaseResourceId=$tenantDatabaseResourceId,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = characterSetName?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (ncharCharacterSetName?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (tenantDatabaseArn?.hashCode() ?: 0)
        result = 31 * result + (tenantDatabaseCreateTime?.hashCode() ?: 0)
        result = 31 * result + (tenantDatabaseResourceId?.hashCode() ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TenantDatabase

        if (characterSetName != other.characterSetName) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (masterUsername != other.masterUsername) return false
        if (ncharCharacterSetName != other.ncharCharacterSetName) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (status != other.status) return false
        if (tagList != other.tagList) return false
        if (tenantDatabaseArn != other.tenantDatabaseArn) return false
        if (tenantDatabaseCreateTime != other.tenantDatabaseCreateTime) return false
        if (tenantDatabaseResourceId != other.tenantDatabaseResourceId) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.TenantDatabase = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The character set of the tenant database.
         */
        public var characterSetName: kotlin.String? = null
        /**
         * The ID of the DB instance that contains the tenant database.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the DB instance.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * Specifies whether deletion protection is enabled for the DB instance.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The master username of the tenant database.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The `NCHAR` character set name of the tenant database.
         */
        public var ncharCharacterSetName: kotlin.String? = null
        /**
         * Information about pending changes for a tenant database.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.rds.model.TenantDatabasePendingModifiedValues? = null
        /**
         * The status of the tenant database.
         */
        public var status: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) for the tenant database.
         */
        public var tenantDatabaseArn: kotlin.String? = null
        /**
         * The creation time of the tenant database.
         */
        public var tenantDatabaseCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region-unique, immutable identifier for the tenant database.
         */
        public var tenantDatabaseResourceId: kotlin.String? = null
        /**
         * The database name of the tenant database.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.TenantDatabase) : this() {
            this.characterSetName = x.characterSetName
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.deletionProtection = x.deletionProtection
            this.masterUsername = x.masterUsername
            this.ncharCharacterSetName = x.ncharCharacterSetName
            this.pendingModifiedValues = x.pendingModifiedValues
            this.status = x.status
            this.tagList = x.tagList
            this.tenantDatabaseArn = x.tenantDatabaseArn
            this.tenantDatabaseCreateTime = x.tenantDatabaseCreateTime
            this.tenantDatabaseResourceId = x.tenantDatabaseResourceId
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.TenantDatabase = TenantDatabase(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.TenantDatabasePendingModifiedValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.rds.model.TenantDatabasePendingModifiedValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.rds.model.TenantDatabasePendingModifiedValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
