// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details about a blue/green deployment.
 *
 * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
 */
public class SwitchoverDetail private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a resource in the blue environment.
     */
    public val sourceMember: kotlin.String? = builder.sourceMember
    /**
     * The switchover status of a resource in a blue/green deployment.
     *
     * Values:
     * + `PROVISIONING` - The resource is being prepared to switch over.
     * + `AVAILABLE` - The resource is ready to switch over.
     * + `SWITCHOVER_IN_PROGRESS` - The resource is being switched over.
     * + `SWITCHOVER_COMPLETED` - The resource has been switched over.
     * + `SWITCHOVER_FAILED` - The resource attempted to switch over but failed.
     * + `MISSING_SOURCE` - The source resource has been deleted.
     * + `MISSING_TARGET` - The target resource has been deleted.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The Amazon Resource Name (ARN) of a resource in the green environment.
     */
    public val targetMember: kotlin.String? = builder.targetMember

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.SwitchoverDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SwitchoverDetail(")
        append("sourceMember=$sourceMember,")
        append("status=$status,")
        append("targetMember=$targetMember")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceMember?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetMember?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SwitchoverDetail

        if (sourceMember != other.sourceMember) return false
        if (status != other.status) return false
        if (targetMember != other.targetMember) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.SwitchoverDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a resource in the blue environment.
         */
        public var sourceMember: kotlin.String? = null
        /**
         * The switchover status of a resource in a blue/green deployment.
         *
         * Values:
         * + `PROVISIONING` - The resource is being prepared to switch over.
         * + `AVAILABLE` - The resource is ready to switch over.
         * + `SWITCHOVER_IN_PROGRESS` - The resource is being switched over.
         * + `SWITCHOVER_COMPLETED` - The resource has been switched over.
         * + `SWITCHOVER_FAILED` - The resource attempted to switch over but failed.
         * + `MISSING_SOURCE` - The source resource has been deleted.
         * + `MISSING_TARGET` - The target resource has been deleted.
         */
        public var status: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of a resource in the green environment.
         */
        public var targetMember: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.SwitchoverDetail) : this() {
            this.sourceMember = x.sourceMember
            this.status = x.status
            this.targetMember = x.targetMember
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.SwitchoverDetail = SwitchoverDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
