// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * A logical grouping of Performance Insights metrics for a related subject area. For example, the `db.sql` dimension group consists of the following dimensions:
 * + `db.sql.id` - The hash of a running SQL statement, generated by Performance Insights.
 * + `db.sql.db_id` - Either the SQL ID generated by the database engine, or a value generated by Performance Insights that begins with `pi-`.
 * + `db.sql.statement` - The full text of the SQL statement that is running, for example, `SELECT * FROM employees`.
 * + `db.sql_tokenized.id` - The hash of the SQL digest generated by Performance Insights.
 *
 * Each response element returns a maximum of 500 bytes. For larger elements, such as SQL statements, only the first 500 bytes are returned.
 */
public class PerformanceInsightsMetricDimensionGroup private constructor(builder: Builder) {
    /**
     * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in the group were requested, or are present in the response.
     */
    public val dimensions: List<String>? = builder.dimensions
    /**
     * The available dimension groups for Performance Insights metric type.
     */
    public val group: kotlin.String? = builder.group
    /**
     * The maximum number of items to fetch for this dimension group.
     */
    public val limit: kotlin.Int? = builder.limit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PerformanceInsightsMetricDimensionGroup(")
        append("dimensions=$dimensions,")
        append("group=$group,")
        append("limit=$limit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dimensions?.hashCode() ?: 0
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PerformanceInsightsMetricDimensionGroup

        if (dimensions != other.dimensions) return false
        if (group != other.group) return false
        if (limit != other.limit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of specific dimensions from a dimension group. If this list isn't included, then all of the dimensions in the group were requested, or are present in the response.
         */
        public var dimensions: List<String>? = null
        /**
         * The available dimension groups for Performance Insights metric type.
         */
        public var group: kotlin.String? = null
        /**
         * The maximum number of items to fetch for this dimension group.
         */
        public var limit: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup) : this() {
            this.dimensions = x.dimensions
            this.group = x.group
            this.limit = x.limit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.PerformanceInsightsMetricDimensionGroup = PerformanceInsightsMetricDimensionGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
