// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class ModifyDbInstanceRequest private constructor(builder: Builder) {
    /**
     * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
     *
     * For RDS for Db2, MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
     *
     * For the valid values for allocated storage for each engine, see `CreateDBInstance`.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Constraints:
     * + Major version upgrades must be allowed when specifying a value for the `EngineVersion` parameter that's a different major version than the DB instance's current version.
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean? = builder.allowMajorVersionUpgrade
    /**
     * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB instance. By default, this parameter is disabled.
     *
     * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to RebootDBInstance, or the next failure reboot. Review the table of parameters in [Modifying a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html) in the *Amazon RDS User Guide* to see the impact of enabling or disabling `ApplyImmediately` for each modified parameter and to determine when the changes are applied.
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Specifies whether minor version upgrades are applied automatically to the DB instance during the maintenance window. An outage occurs when all the following conditions are met:
     * + The automatic upgrade is enabled for the maintenance window.
     * + A newer minor version is available.
     * + RDS has enabled automatic patching for the engine version.
     *
     * If any of the preceding conditions isn't met, Amazon RDS applies the change as soon as possible and doesn't cause an outage.
     *
     * For an RDS Custom DB instance, don't enable this setting. Otherwise, the operation returns an error.
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * The automation mode of the RDS Custom DB instance. If `full`, the DB instance automates monitoring and instance recovery. If `all paused`, the instance pauses automation for the duration set by `ResumeFullAutomationModeMinutes`.
     */
    public val automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = builder.automationMode
    /**
     * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val awsBackupRecoveryPointArn: kotlin.String? = builder.awsBackupRecoveryPointArn
    /**
     * The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
     *
     * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.
     *
     * These changes are applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.
     *
     * This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups is managed by the DB cluster. For more information, see `ModifyDBCluster`.
     *
     * Default: Uses existing setting
     *
     * Constraints:
     * + Must be a value from 0 to 35.
     * + Can't be set to 0 if the DB instance is a source to read replicas.
     * + Can't be set to 0 for an RDS Custom for Oracle DB instance.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The CA certificate identifier to use for the DB instance's server certificate.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
     *
     * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
     *
     * Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
     *
     * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
     * + For more information about rotating your SSL/TLS certificate for RDS DB engines, see [ Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
     * + For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [ Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val certificateRotationRestart: kotlin.Boolean? = builder.certificateRotationRestart
    /**
     * The log types to be enabled for export to CloudWatch Logs for a specific DB instance.
     *
     * A change to the `CloudwatchLogsExportConfiguration` parameter is always applied to the DB instance immediately. Therefore, the `ApplyImmediately` parameter has no effect.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = builder.cloudwatchLogsExportConfiguration
    /**
     * Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags aren't copied.
     *
     * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see `ModifyDBCluster`.
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The new compute and memory capacity of the DB instance, for example `db.m4.large`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*. For RDS Custom, see [DB instance class support for RDS Custom for Oracle](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.instances) and [ DB instance class support for RDS Custom for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html#custom-reqs-limits.instancesMS).
     *
     * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless you specify `ApplyImmediately` in your request.
     *
     * Default: Uses existing setting
     *
     * Constraints:
     * + If you are modifying the DB instance class and upgrading the engine version at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The identifier of DB instance to modify. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must match the identifier of an existing DB instance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the DB parameter group to apply to the DB instance.
     *
     * Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn't rebooted automatically, and the parameter changes aren't applied during the next maintenance window. However, if you modify dynamic parameters in the newly associated DB parameter group, these changes are applied immediately without a reboot.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Default: Uses existing setting
     *
     * Constraints:
     * + Must be in the same DB parameter group family as the DB instance.
     */
    public val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The port number on which the database accepts connections.
     *
     * The value of the `DBPortNumber` parameter must not match any of the port values specified for options in the option group for the DB instance.
     *
     * If you change the `DBPortNumber` value, your database restarts regardless of the value of the `ApplyImmediately` parameter.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Valid Values: `1150-65535`
     *
     * Default:
     * + Amazon Aurora - `3306`
     * + RDS for Db2 - `50000`
     * + RDS for MariaDB - `3306`
     * + RDS for Microsoft SQL Server - `1433`
     * + RDS for MySQL - `3306`
     * + RDS for Oracle - `1521`
     * + RDS for PostgreSQL - `5432`
     *
     * Constraints:
     * + For RDS for Microsoft SQL Server, the value can't be `1234`, `1434`, `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
     */
    public val dbPortNumber: kotlin.Int? = builder.dbPortNumber
    /**
     * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Constraints:
     * + If supplied, must match existing DB security groups.
     */
    public val dbSecurityGroups: List<String>? = builder.dbSecurityGroups
    /**
     * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC) in the *Amazon RDS User Guide*.
     *
     * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable `ApplyImmediately`.
     *
     * This parameter doesn't apply to RDS Custom DB instances.
     *
     * Constraints:
     * + If supplied, must match existing DB subnet group.
     *
     * Example: `mydbsubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
     */
    public val dedicatedLogVolume: kotlin.Boolean? = builder.dedicatedLogVolume
    /**
     * Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * Specifies whether to remove the DB instance from the Active Directory domain.
     */
    public val disableDomain: kotlin.Boolean? = builder.disableDomain
    /**
     * The Active Directory directory ID to move the DB instance to. Specify `none` to remove the instance from its current domain. You must create the domain before this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
     *
     * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
     *
     * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
     */
    public val domainAuthSecretArn: kotlin.String? = builder.domainAuthSecretArn
    /**
     * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
     *
     * Constraints:
     * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
     *
     * Example: `123.124.125.126,234.235.236.237`
     */
    public val domainDnsIps: List<String>? = builder.domainDnsIps
    /**
     * The fully qualified domain name (FQDN) of an Active Directory domain.
     *
     * Constraints:
     * + Can't be longer than 64 characters.
     *
     * Example: `mymanagedADtest.mymanagedAD.mydomain`
     */
    public val domainFqdn: kotlin.String? = builder.domainFqdn
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The Active Directory organizational unit for your DB instance to join.
     *
     * Constraints:
     * + Must be in the distinguished name format.
     * + Can't be longer than 64 characters.
     *
     * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
     */
    public val domainOu: kotlin.String? = builder.domainOu
    /**
     * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
     *
     * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
     *
     * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
     *
     * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
     */
    public val enableCustomerOwnedIp: kotlin.Boolean? = builder.enableCustomerOwnedIp
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.
     *
     * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * Specifies whether to enable Performance Insights for the DB instance.
     *
     * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The target Oracle DB engine when you convert a non-CDB to a CDB. This intermediate step is necessary to upgrade an Oracle Database 19c non-CDB to an Oracle Database 21c CDB.
     *
     * Note the following requirements:
     * + Make sure that you specify `oracle-ee-cdb` or `oracle-se2-cdb`.
     * + Make sure that your DB engine runs Oracle Database 19c with an April 2021 or later RU.
     *
     * Note the following limitations:
     * + You can't convert a CDB to a non-CDB.
     * + You can't convert a replica database.
     * + You can't convert a non-CDB to a CDB and upgrade the engine version in the same command.
     * + You can't convert the existing custom parameter or option group when it has options or parameters that are permanent or persistent. In this situation, the DB instance reverts to the default option and parameter group. To avoid reverting to the default, specify a new parameter group with `--db-parameter-group-name` and a new option group with `--option-group-name`.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
     *
     * For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.
     *
     * If you specify only a major version, Amazon RDS updates the DB instance to the default minor version if the current minor version is lower. For information about valid engine versions, see `CreateDBInstance`, or call `DescribeDBEngineVersions`.
     *
     * If the instance that you're modifying is acting as a read replica, the engine version that you specify must be the same or higher than the version that the source DB instance or cluster is running.
     *
     * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the `PATCH_DB_FAILURE` lifecycle.
     *
     * Constraints:
     * + If you are upgrading the engine version and modifying the DB instance class at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
     *
     * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.
     *
     * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.
     *
     * Constraints:
     * + For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL - The value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
     *
     * Default: Uses existing setting
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The license model for the DB instance.
     *
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     *
     * Valid Values:
     * + RDS for Db2 - `bring-your-own-license`
     * + RDS for MariaDB - `general-public-license`
     * + RDS for Microsoft SQL Server - `license-included`
     * + RDS for MySQL - `general-public-license`
     * + RDS for Oracle - `bring-your-own-license | license-included`
     * + RDS for PostgreSQL - `postgresql-license`
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     *
     * If the DB instance doesn't manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can't specify `MasterUserPassword`.
     *
     * If the DB instance already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify `MasterUserPassword`. In this case, Amazon RDS deletes the secret and uses the new password for the master user specified by `MasterUserPassword`.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
     *
     * Constraints:
     * + Can't manage the master user password with Amazon Web Services Secrets Manager if `MasterUserPassword` is specified.
     */
    public val manageMasterUserPassword: kotlin.Boolean? = builder.manageMasterUserPassword
    /**
     * The new password for the master user.
     *
     * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the `MasterUserPassword` element exists in the `PendingModifiedValues` element of the operation response.
     *
     * Amazon RDS API operations never return the password, so this operation provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked.
     *
     * This setting doesn't apply to the following DB instances:
     * + Amazon Aurora (The password for the master user is managed by the DB cluster. For more information, see `ModifyDBCluster`.)
     * + RDS Custom
     *
     * Default: Uses existing setting
     *
     * Constraints:
     * + Can't be specified if `ManageMasterUserPassword` is turned on.
     * + Can include any printable ASCII character except "/", """, or "@". For RDS for Oracle, can't include the "&" (ampersand) or the "'" (single quotes) character.
     *
     * Length Constraints:
     * + RDS for Db2 - Must contain from 8 to 255 characters.
     * + RDS for MariaDB - Must contain from 8 to 41 characters.
     * + RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
     * + RDS for MySQL - Must contain from 8 to 41 characters.
     * + RDS for Oracle - Must contain from 8 to 30 characters.
     * + RDS for PostgreSQL - Must contain from 8 to 128 characters.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
     *
     * This setting is valid only if both of the following conditions are met:
     * + The DB instance doesn't manage the master user password in Amazon Web Services Secrets Manager.If the DB instance already manages the master user password in Amazon Web Services Secrets Manager, you can't change the KMS key used to encrypt the secret.
     * + You are turning on `ManageMasterUserPassword` to manage the master user password in Amazon Web Services Secrets Manager.If you are turning on `ManageMasterUserPassword` and don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     */
    public val masterUserSecretKmsKeyId: kotlin.String? = builder.masterUserSecretKmsKeyId
    /**
     * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
     *
     * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val maxAllocatedStorage: kotlin.Int? = builder.maxAllocatedStorage
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify `0`.
     *
     * If `MonitoringRoleArn` is specified, set `MonitoringInterval` to a value other than `0`.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
     *
     * Default: `0`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
     *
     * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * Specifies whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage. The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val multiAz: kotlin.Boolean? = builder.multiAz
    /**
     * Specifies whether the to convert your DB instance from the single-tenant conﬁguration to the multi-tenant conﬁguration. This parameter is supported only for RDS for Oracle CDB instances.
     *
     * During the conversion, RDS creates an initial tenant database and associates the DB name, master user name, character set, and national character set metadata with this database. The tags associated with the instance also propagate to the initial tenant database. You can add more tenant databases to your DB instance by using the `CreateTenantDatabase` operation.
     *
     * The conversion to the multi-tenant configuration is permanent and irreversible, so you can't later convert back to the single-tenant configuration. When you specify this parameter, you must also specify `ApplyImmediately`.
     */
    public val multiTenant: kotlin.Boolean? = builder.multiTenant
    /**
     * The network type of the DB instance.
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     *
     * Valid Values: `IPV4 | DUAL`
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The new identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable `ApplyImmediately`, or will occur during the next maintenance window if you disable `ApplyImmediately`. This value is stored as a lowercase string.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens.
     * + The first character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `mydbinstance`
     */
    public val newDbInstanceIdentifier: kotlin.String? = builder.newDbInstanceIdentifier
    /**
     * The option group to associate the DB instance with.
     *
     * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which new connections are rejected but existing connections aren't interrupted.
     *
     * The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
     *
     * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Valid Values:
     * + `7`
     * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
     * + `731`
     *
     * Default: `7` days
     *
     * If you specify a retention period that isn't valid, such as `94`, Amazon RDS returns an error.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod` parameter. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see [Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated backups is managed by the DB cluster. For more information, see `ModifyDBCluster`.
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter causes a reboot of the DB instance. If you change this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.
     *
     * For more information, see [Amazon RDS Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance) in the *Amazon RDS User Guide.*
     *
     * Default: Uses existing setting
     *
     * Constraints:
     * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
     * + The day values must be `mon | tue | wed | thu | fri | sat | sun`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred backup window.
     * + Must be at least 30 minutes.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val processorFeatures: List<ProcessorFeature>? = builder.processorFeatures
    /**
     * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     *
     * Default: `1`
     *
     * Valid Values: `0 - 15`
     */
    public val promotionTier: kotlin.Int? = builder.promotionTier
    /**
     * Specifies whether the DB instance is publicly accessible.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
     *
     * `PubliclyAccessible` only applies to DB instances in a VPC. The DB instance must be part of a public subnet and `PubliclyAccessible` must be enabled for it to be publicly accessible.
     *
     * Changes to the `PubliclyAccessible` parameter are applied immediately regardless of the value of the `ApplyImmediately` parameter.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * A value that sets the open mode of a replica database to either mounted or read-only.
     *
     * Currently, this parameter is only supported for Oracle DB instances.
     *
     * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = builder.replicaMode
    /**
     * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.
     *
     * Default: `60`
     *
     * Constraints:
     * + Must be at least 60.
     * + Must be no more than 1,440.
     */
    public val resumeFullAutomationModeMinutes: kotlin.Int? = builder.resumeFullAutomationModeMinutes
    /**
     * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.
     *
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
     *
     * Constraints:
     * + You must apply the change immediately when rotating the master user password.
     */
    public val rotateMasterUserPassword: kotlin.Boolean? = builder.rotateMasterUserPassword
    /**
     * The storage throughput value for the DB instance.
     *
     * This setting applies only to the `gp3` storage type.
     *
     * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
     */
    public val storageThroughput: kotlin.Int? = builder.storageThroughput
    /**
     * The storage type to associate with the DB instance.
     *
     * If you specify Provisioned IOPS (`io1`), you must also include a value for the `Iops` parameter.
     *
     * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.
     *
     * Valid Values: `gp2 | gp3 | io1 | standard`
     *
     * Default: `io1`, if the `Iops` parameter is specified. Otherwise, `gp2`.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The ARN from the key store with which to associate the instance for TDE encryption.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val tdeCredentialArn: kotlin.String? = builder.tdeCredentialArn
    /**
     * The password for the given ARN from the key store in order to access the device.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val tdeCredentialPassword: kotlin.String? = builder.tdeCredentialPassword
    /**
     * Specifies whether the DB instance class of the DB instance uses its default processor features.
     *
     * This setting doesn't apply to RDS Custom DB instances.
     */
    public val useDefaultProcessorFeatures: kotlin.Boolean? = builder.useDefaultProcessorFeatures
    /**
     * A list of Amazon EC2 VPC security groups to associate with this DB instance. This change is asynchronously applied as soon as possible.
     *
     * This setting doesn't apply to the following DB instances:
     * + Amazon Aurora (The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see `ModifyDBCluster`.)
     * + RDS Custom
     *
     * Constraints:
     * + If supplied, must match existing VPC security group IDs.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbInstanceRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("applyImmediately=$applyImmediately,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("automationMode=$automationMode,")
        append("awsBackupRecoveryPointArn=$awsBackupRecoveryPointArn,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("certificateRotationRestart=$certificateRotationRestart,")
        append("cloudwatchLogsExportConfiguration=$cloudwatchLogsExportConfiguration,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("dbPortNumber=$dbPortNumber,")
        append("dbSecurityGroups=$dbSecurityGroups,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("dedicatedLogVolume=$dedicatedLogVolume,")
        append("deletionProtection=$deletionProtection,")
        append("disableDomain=$disableDomain,")
        append("domain=$domain,")
        append("domainAuthSecretArn=$domainAuthSecretArn,")
        append("domainDnsIps=$domainDnsIps,")
        append("domainFqdn=$domainFqdn,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("domainOu=$domainOu,")
        append("enableCustomerOwnedIp=$enableCustomerOwnedIp,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("iops=$iops,")
        append("licenseModel=$licenseModel,")
        append("manageMasterUserPassword=$manageMasterUserPassword,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUserSecretKmsKeyId=$masterUserSecretKmsKeyId,")
        append("maxAllocatedStorage=$maxAllocatedStorage,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("multiAz=$multiAz,")
        append("multiTenant=$multiTenant,")
        append("networkType=$networkType,")
        append("newDbInstanceIdentifier=$newDbInstanceIdentifier,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("processorFeatures=$processorFeatures,")
        append("promotionTier=$promotionTier,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("replicaMode=$replicaMode,")
        append("resumeFullAutomationModeMinutes=$resumeFullAutomationModeMinutes,")
        append("rotateMasterUserPassword=$rotateMasterUserPassword,")
        append("storageThroughput=$storageThroughput,")
        append("storageType=$storageType,")
        append("tdeCredentialArn=$tdeCredentialArn,")
        append("tdeCredentialPassword=$tdeCredentialPassword,")
        append("useDefaultProcessorFeatures=$useDefaultProcessorFeatures,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (allowMajorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (applyImmediately?.hashCode() ?: 0)
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (automationMode?.hashCode() ?: 0)
        result = 31 * result + (awsBackupRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (certificateRotationRestart?.hashCode() ?: 0)
        result = 31 * result + (cloudwatchLogsExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbPortNumber ?: 0)
        result = 31 * result + (dbSecurityGroups?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dedicatedLogVolume?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (disableDomain?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainAuthSecretArn?.hashCode() ?: 0)
        result = 31 * result + (domainDnsIps?.hashCode() ?: 0)
        result = 31 * result + (domainFqdn?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (domainOu?.hashCode() ?: 0)
        result = 31 * result + (enableCustomerOwnedIp?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (manageMasterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (maxAllocatedStorage ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (multiAz?.hashCode() ?: 0)
        result = 31 * result + (multiTenant?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (newDbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (processorFeatures?.hashCode() ?: 0)
        result = 31 * result + (promotionTier ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (replicaMode?.hashCode() ?: 0)
        result = 31 * result + (resumeFullAutomationModeMinutes ?: 0)
        result = 31 * result + (rotateMasterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (storageThroughput ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialArn?.hashCode() ?: 0)
        result = 31 * result + (tdeCredentialPassword?.hashCode() ?: 0)
        result = 31 * result + (useDefaultProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbInstanceRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (applyImmediately != other.applyImmediately) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (automationMode != other.automationMode) return false
        if (awsBackupRecoveryPointArn != other.awsBackupRecoveryPointArn) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (certificateRotationRestart != other.certificateRotationRestart) return false
        if (cloudwatchLogsExportConfiguration != other.cloudwatchLogsExportConfiguration) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (dbPortNumber != other.dbPortNumber) return false
        if (dbSecurityGroups != other.dbSecurityGroups) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (dedicatedLogVolume != other.dedicatedLogVolume) return false
        if (deletionProtection != other.deletionProtection) return false
        if (disableDomain != other.disableDomain) return false
        if (domain != other.domain) return false
        if (domainAuthSecretArn != other.domainAuthSecretArn) return false
        if (domainDnsIps != other.domainDnsIps) return false
        if (domainFqdn != other.domainFqdn) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (domainOu != other.domainOu) return false
        if (enableCustomerOwnedIp != other.enableCustomerOwnedIp) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (iops != other.iops) return false
        if (licenseModel != other.licenseModel) return false
        if (manageMasterUserPassword != other.manageMasterUserPassword) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUserSecretKmsKeyId != other.masterUserSecretKmsKeyId) return false
        if (maxAllocatedStorage != other.maxAllocatedStorage) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (multiAz != other.multiAz) return false
        if (multiTenant != other.multiTenant) return false
        if (networkType != other.networkType) return false
        if (newDbInstanceIdentifier != other.newDbInstanceIdentifier) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (processorFeatures != other.processorFeatures) return false
        if (promotionTier != other.promotionTier) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (replicaMode != other.replicaMode) return false
        if (resumeFullAutomationModeMinutes != other.resumeFullAutomationModeMinutes) return false
        if (rotateMasterUserPassword != other.rotateMasterUserPassword) return false
        if (storageThroughput != other.storageThroughput) return false
        if (storageType != other.storageType) return false
        if (tdeCredentialArn != other.tdeCredentialArn) return false
        if (tdeCredentialPassword != other.tdeCredentialPassword) return false
        if (useDefaultProcessorFeatures != other.useDefaultProcessorFeatures) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The new amount of storage in gibibytes (GiB) to allocate for the DB instance.
         *
         * For RDS for Db2, MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
         *
         * For the valid values for allocated storage for each engine, see `CreateDBInstance`.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Constraints:
         * + Major version upgrades must be allowed when specifying a value for the `EngineVersion` parameter that's a different major version than the DB instance's current version.
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Specifies whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the `PreferredMaintenanceWindow` setting for the DB instance. By default, this parameter is disabled.
         *
         * If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to RebootDBInstance, or the next failure reboot. Review the table of parameters in [Modifying a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html) in the *Amazon RDS User Guide* to see the impact of enabling or disabling `ApplyImmediately` for each modified parameter and to determine when the changes are applied.
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * Specifies whether minor version upgrades are applied automatically to the DB instance during the maintenance window. An outage occurs when all the following conditions are met:
         * + The automatic upgrade is enabled for the maintenance window.
         * + A newer minor version is available.
         * + RDS has enabled automatic patching for the engine version.
         *
         * If any of the preceding conditions isn't met, Amazon RDS applies the change as soon as possible and doesn't cause an outage.
         *
         * For an RDS Custom DB instance, don't enable this setting. Otherwise, the operation returns an error.
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * The automation mode of the RDS Custom DB instance. If `full`, the DB instance automates monitoring and instance recovery. If `all paused`, the instance pauses automation for the duration set by `ResumeFullAutomationModeMinutes`.
         */
        public var automationMode: aws.sdk.kotlin.services.rds.model.AutomationMode? = null
        /**
         * The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var awsBackupRecoveryPointArn: kotlin.String? = null
        /**
         * The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.
         *
         * Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.
         *
         * These changes are applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.
         *
         * This setting doesn't apply to Amazon Aurora DB instances. The retention period for automated backups is managed by the DB cluster. For more information, see `ModifyDBCluster`.
         *
         * Default: Uses existing setting
         *
         * Constraints:
         * + Must be a value from 0 to 35.
         * + Can't be set to 0 if the DB instance is a source to read replicas.
         * + Can't be set to 0 for an RDS Custom for Oracle DB instance.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The CA certificate identifier to use for the DB instance's server certificate.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * Specifies whether the DB instance is restarted when you rotate your SSL/TLS certificate.
         *
         * By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.
         *
         * Set this parameter only if you are *not* using SSL/TLS to connect to the DB instance.
         *
         * If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:
         * + For more information about rotating your SSL/TLS certificate for RDS DB engines, see [ Rotating Your SSL/TLS Certificate.](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon RDS User Guide.*
         * + For more information about rotating your SSL/TLS certificate for Aurora DB engines, see [ Rotating Your SSL/TLS Certificate](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html) in the *Amazon Aurora User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var certificateRotationRestart: kotlin.Boolean? = null
        /**
         * The log types to be enabled for export to CloudWatch Logs for a specific DB instance.
         *
         * A change to the `CloudwatchLogsExportConfiguration` parameter is always applied to the DB instance immediately. Therefore, the `ApplyImmediately` parameter has no effect.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var cloudwatchLogsExportConfiguration: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration? = null
        /**
         * Specifies whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags aren't copied.
         *
         * This setting doesn't apply to Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see `ModifyDBCluster`.
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The new compute and memory capacity of the DB instance, for example `db.m4.large`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see [DB Instance Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide* or [Aurora DB instance classes](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html) in the *Amazon Aurora User Guide*. For RDS Custom, see [DB instance class support for RDS Custom for Oracle](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.instances) and [ DB instance class support for RDS Custom for SQL Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html#custom-reqs-limits.instancesMS).
         *
         * If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless you specify `ApplyImmediately` in your request.
         *
         * Default: Uses existing setting
         *
         * Constraints:
         * + If you are modifying the DB instance class and upgrading the engine version at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The identifier of DB instance to modify. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must match the identifier of an existing DB instance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the DB parameter group to apply to the DB instance.
         *
         * Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn't rebooted automatically, and the parameter changes aren't applied during the next maintenance window. However, if you modify dynamic parameters in the newly associated DB parameter group, these changes are applied immediately without a reboot.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Default: Uses existing setting
         *
         * Constraints:
         * + Must be in the same DB parameter group family as the DB instance.
         */
        public var dbParameterGroupName: kotlin.String? = null
        /**
         * The port number on which the database accepts connections.
         *
         * The value of the `DBPortNumber` parameter must not match any of the port values specified for options in the option group for the DB instance.
         *
         * If you change the `DBPortNumber` value, your database restarts regardless of the value of the `ApplyImmediately` parameter.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Valid Values: `1150-65535`
         *
         * Default:
         * + Amazon Aurora - `3306`
         * + RDS for Db2 - `50000`
         * + RDS for MariaDB - `3306`
         * + RDS for Microsoft SQL Server - `1433`
         * + RDS for MySQL - `3306`
         * + RDS for Oracle - `1521`
         * + RDS for PostgreSQL - `5432`
         *
         * Constraints:
         * + For RDS for Microsoft SQL Server, the value can't be `1234`, `1434`, `3260`, `3343`, `3389`, `47001`, or `49152-49156`.
         */
        public var dbPortNumber: kotlin.Int? = null
        /**
         * A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Constraints:
         * + If supplied, must match existing DB security groups.
         */
        public var dbSecurityGroups: List<String>? = null
        /**
         * The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see [Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC) in the *Amazon RDS User Guide*.
         *
         * Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable `ApplyImmediately`.
         *
         * This parameter doesn't apply to RDS Custom DB instances.
         *
         * Constraints:
         * + If supplied, must match existing DB subnet group.
         *
         * Example: `mydbsubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Indicates whether the DB instance has a dedicated log volume (DLV) enabled.
         */
        public var dedicatedLogVolume: kotlin.Boolean? = null
        /**
         * Specifies whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see [ Deleting a DB Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * Specifies whether to remove the DB instance from the Active Directory domain.
         */
        public var disableDomain: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to move the DB instance to. Specify `none` to remove the instance from its current domain. You must create the domain before this operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
         *
         * For more information, see [ Kerberos Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var domain: kotlin.String? = null
        /**
         * The ARN for the Secrets Manager secret with the credentials for the user joining the domain.
         *
         * Example: `arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456`
         */
        public var domainAuthSecretArn: kotlin.String? = null
        /**
         * The IPv4 DNS IP addresses of your primary and secondary Active Directory domain controllers.
         *
         * Constraints:
         * + Two IP addresses must be provided. If there isn't a secondary domain controller, use the IP address of the primary domain controller for both entries in the list.
         *
         * Example: `123.124.125.126,234.235.236.237`
         */
        public var domainDnsIps: List<String>? = null
        /**
         * The fully qualified domain name (FQDN) of an Active Directory domain.
         *
         * Constraints:
         * + Can't be longer than 64 characters.
         *
         * Example: `mymanagedADtest.mymanagedAD.mydomain`
         */
        public var domainFqdn: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The Active Directory organizational unit for your DB instance to join.
         *
         * Constraints:
         * + Must be in the distinguished name format.
         * + Can't be longer than 64 characters.
         *
         * Example: `OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain`
         */
        public var domainOu: kotlin.String? = null
        /**
         * Specifies whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.
         *
         * A *CoIP* provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.
         *
         * For more information about RDS on Outposts, see [Working with Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide*.
         *
         * For more information about CoIPs, see [Customer-owned IP addresses](https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing) in the *Amazon Web Services Outposts User Guide*.
         */
        public var enableCustomerOwnedIp: kotlin.Boolean? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.
         *
         * For more information about IAM database authentication, see [ IAM Database Authentication for MySQL and PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon RDS User Guide.*
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * Specifies whether to enable Performance Insights for the DB instance.
         *
         * For more information, see [Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The target Oracle DB engine when you convert a non-CDB to a CDB. This intermediate step is necessary to upgrade an Oracle Database 19c non-CDB to an Oracle Database 21c CDB.
         *
         * Note the following requirements:
         * + Make sure that you specify `oracle-ee-cdb` or `oracle-se2-cdb`.
         * + Make sure that your DB engine runs Oracle Database 19c with an April 2021 or later RU.
         *
         * Note the following limitations:
         * + You can't convert a CDB to a non-CDB.
         * + You can't convert a replica database.
         * + You can't convert a non-CDB to a CDB and upgrade the engine version in the same command.
         * + You can't convert the existing custom parameter or option group when it has options or parameters that are permanent or persistent. In this situation, the DB instance reverts to the default option and parameter group. To avoid reverting to the default, specify a new parameter group with `--db-parameter-group-name` and a new option group with `--option-group-name`.
         */
        public var engine: kotlin.String? = null
        /**
         * The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
         *
         * For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.
         *
         * If you specify only a major version, Amazon RDS updates the DB instance to the default minor version if the current minor version is lower. For information about valid engine versions, see `CreateDBInstance`, or call `DescribeDBEngineVersions`.
         *
         * If the instance that you're modifying is acting as a read replica, the engine version that you specify must be the same or higher than the version that the source DB instance or cluster is running.
         *
         * In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the `PATCH_DB_FAILURE` lifecycle.
         *
         * Constraints:
         * + If you are upgrading the engine version and modifying the DB instance class at the same time, the currently running engine version must be supported on the specified DB instance class. Otherwise, the operation returns an error. In this case, first run the operation to upgrade the engine version, and then run it again to modify the DB instance class.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The new Provisioned IOPS (I/O operations per second) value for the RDS instance.
         *
         * Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.
         *
         * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.
         *
         * Constraints:
         * + For RDS for MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL - The value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.
         *
         * Default: Uses existing setting
         */
        public var iops: kotlin.Int? = null
        /**
         * The license model for the DB instance.
         *
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         *
         * Valid Values:
         * + RDS for Db2 - `bring-your-own-license`
         * + RDS for MariaDB - `general-public-license`
         * + RDS for Microsoft SQL Server - `license-included`
         * + RDS for MySQL - `general-public-license`
         * + RDS for Oracle - `bring-your-own-license | license-included`
         * + RDS for PostgreSQL - `postgresql-license`
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         *
         * If the DB instance doesn't manage the master user password with Amazon Web Services Secrets Manager, you can turn on this management. In this case, you can't specify `MasterUserPassword`.
         *
         * If the DB instance already manages the master user password with Amazon Web Services Secrets Manager, and you specify that the master user password is not managed with Amazon Web Services Secrets Manager, then you must specify `MasterUserPassword`. In this case, Amazon RDS deletes the secret and uses the new password for the master user specified by `MasterUserPassword`.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
         *
         * Constraints:
         * + Can't manage the master user password with Amazon Web Services Secrets Manager if `MasterUserPassword` is specified.
         */
        public var manageMasterUserPassword: kotlin.Boolean? = null
        /**
         * The new password for the master user.
         *
         * Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the `MasterUserPassword` element exists in the `PendingModifiedValues` element of the operation response.
         *
         * Amazon RDS API operations never return the password, so this operation provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked.
         *
         * This setting doesn't apply to the following DB instances:
         * + Amazon Aurora (The password for the master user is managed by the DB cluster. For more information, see `ModifyDBCluster`.)
         * + RDS Custom
         *
         * Default: Uses existing setting
         *
         * Constraints:
         * + Can't be specified if `ManageMasterUserPassword` is turned on.
         * + Can include any printable ASCII character except "/", """, or "@". For RDS for Oracle, can't include the "&" (ampersand) or the "'" (single quotes) character.
         *
         * Length Constraints:
         * + RDS for Db2 - Must contain from 8 to 255 characters.
         * + RDS for MariaDB - Must contain from 8 to 41 characters.
         * + RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.
         * + RDS for MySQL - Must contain from 8 to 41 characters.
         * + RDS for Oracle - Must contain from 8 to 30 characters.
         * + RDS for PostgreSQL - Must contain from 8 to 128 characters.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
         *
         * This setting is valid only if both of the following conditions are met:
         * + The DB instance doesn't manage the master user password in Amazon Web Services Secrets Manager.If the DB instance already manages the master user password in Amazon Web Services Secrets Manager, you can't change the KMS key used to encrypt the secret.
         * + You are turning on `ManageMasterUserPassword` to manage the master user password in Amazon Web Services Secrets Manager.If you are turning on `ManageMasterUserPassword` and don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         */
        public var masterUserSecretKmsKeyId: kotlin.String? = null
        /**
         * The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.
         *
         * For more information about this setting, including limitations that apply to it, see [ Managing capacity automatically with Amazon RDS storage autoscaling](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var maxAllocatedStorage: kotlin.Int? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify `0`.
         *
         * If `MonitoringRoleArn` is specified, set `MonitoringInterval` to a value other than `0`.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
         *
         * Default: `0`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [To create an IAM role for Amazon RDS Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole) in the *Amazon RDS User Guide.*
         *
         * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * Specifies whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage. The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var multiAz: kotlin.Boolean? = null
        /**
         * Specifies whether the to convert your DB instance from the single-tenant conﬁguration to the multi-tenant conﬁguration. This parameter is supported only for RDS for Oracle CDB instances.
         *
         * During the conversion, RDS creates an initial tenant database and associates the DB name, master user name, character set, and national character set metadata with this database. The tags associated with the instance also propagate to the initial tenant database. You can add more tenant databases to your DB instance by using the `CreateTenantDatabase` operation.
         *
         * The conversion to the multi-tenant configuration is permanent and irreversible, so you can't later convert back to the single-tenant configuration. When you specify this parameter, you must also specify `ApplyImmediately`.
         */
        public var multiTenant: kotlin.Boolean? = null
        /**
         * The network type of the DB instance.
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB instance. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         *
         * Valid Values: `IPV4 | DUAL`
         */
        public var networkType: kotlin.String? = null
        /**
         * The new identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable `ApplyImmediately`, or will occur during the next maintenance window if you disable `ApplyImmediately`. This value is stored as a lowercase string.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens.
         * + The first character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `mydbinstance`
         */
        public var newDbInstanceIdentifier: kotlin.String? = null
        /**
         * The option group to associate the DB instance with.
         *
         * Changing this parameter doesn't result in an outage, with one exception. If the parameter change results in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which new connections are rejected but existing connections aren't interrupted.
         *
         * The change is applied during the next maintenance window unless the `ApplyImmediately` parameter is enabled for this request.
         *
         * Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Valid Values:
         * + `7`
         * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
         * + `731`
         *
         * Default: `7` days
         *
         * If you specify a retention period that isn't valid, such as `94`, Amazon RDS returns an error.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled, as determined by the `BackupRetentionPeriod` parameter. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see [Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to Amazon Aurora DB instances. The daily time range for creating automated backups is managed by the DB cluster. For more information, see `ModifyDBCluster`.
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter causes a reboot of the DB instance. If you change this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.
         *
         * For more information, see [Amazon RDS Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance) in the *Amazon RDS User Guide.*
         *
         * Default: Uses existing setting
         *
         * Constraints:
         * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
         * + The day values must be `mon | tue | wed | thu | fri | sat | sun`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred backup window.
         * + Must be at least 30 minutes.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var processorFeatures: List<ProcessorFeature>? = null
        /**
         * The order of priority in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see [ Fault Tolerance for an Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.AuroraHighAvailability.html#Aurora.Managing.FaultTolerance) in the *Amazon Aurora User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         *
         * Default: `1`
         *
         * Valid Values: `0 - 15`
         */
        public var promotionTier: kotlin.Int? = null
        /**
         * Specifies whether the DB instance is publicly accessible.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.
         *
         * `PubliclyAccessible` only applies to DB instances in a VPC. The DB instance must be part of a public subnet and `PubliclyAccessible` must be enabled for it to be publicly accessible.
         *
         * Changes to the `PubliclyAccessible` parameter are applied immediately regardless of the value of the `ApplyImmediately` parameter.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * A value that sets the open mode of a replica database to either mounted or read-only.
         *
         * Currently, this parameter is only supported for Oracle DB instances.
         *
         * Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload. For more information, see [Working with Oracle Read Replicas for Amazon RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html) in the *Amazon RDS User Guide*.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var replicaMode: aws.sdk.kotlin.services.rds.model.ReplicaMode? = null
        /**
         * The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation.
         *
         * Default: `60`
         *
         * Constraints:
         * + Must be at least 60.
         * + Must be no more than 1,440.
         */
        public var resumeFullAutomationModeMinutes: kotlin.Int? = null
        /**
         * Specifies whether to rotate the secret managed by Amazon Web Services Secrets Manager for the master user password.
         *
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster. The secret value contains the updated password.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide.*
         *
         * Constraints:
         * + You must apply the change immediately when rotating the master user password.
         */
        public var rotateMasterUserPassword: kotlin.Boolean? = null
        /**
         * The storage throughput value for the DB instance.
         *
         * This setting applies only to the `gp3` storage type.
         *
         * This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
         */
        public var storageThroughput: kotlin.Int? = null
        /**
         * The storage type to associate with the DB instance.
         *
         * If you specify Provisioned IOPS (`io1`), you must also include a value for the `Iops` parameter.
         *
         * If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.
         *
         * Valid Values: `gp2 | gp3 | io1 | standard`
         *
         * Default: `io1`, if the `Iops` parameter is specified. Otherwise, `gp2`.
         */
        public var storageType: kotlin.String? = null
        /**
         * The ARN from the key store with which to associate the instance for TDE encryption.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var tdeCredentialArn: kotlin.String? = null
        /**
         * The password for the given ARN from the key store in order to access the device.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var tdeCredentialPassword: kotlin.String? = null
        /**
         * Specifies whether the DB instance class of the DB instance uses its default processor features.
         *
         * This setting doesn't apply to RDS Custom DB instances.
         */
        public var useDefaultProcessorFeatures: kotlin.Boolean? = null
        /**
         * A list of Amazon EC2 VPC security groups to associate with this DB instance. This change is asynchronously applied as soon as possible.
         *
         * This setting doesn't apply to the following DB instances:
         * + Amazon Aurora (The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see `ModifyDBCluster`.)
         * + RDS Custom
         *
         * Constraints:
         * + If supplied, must match existing VPC security group IDs.
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.applyImmediately = x.applyImmediately
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.automationMode = x.automationMode
            this.awsBackupRecoveryPointArn = x.awsBackupRecoveryPointArn
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.certificateRotationRestart = x.certificateRotationRestart
            this.cloudwatchLogsExportConfiguration = x.cloudwatchLogsExportConfiguration
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.dbInstanceClass = x.dbInstanceClass
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbParameterGroupName = x.dbParameterGroupName
            this.dbPortNumber = x.dbPortNumber
            this.dbSecurityGroups = x.dbSecurityGroups
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.dedicatedLogVolume = x.dedicatedLogVolume
            this.deletionProtection = x.deletionProtection
            this.disableDomain = x.disableDomain
            this.domain = x.domain
            this.domainAuthSecretArn = x.domainAuthSecretArn
            this.domainDnsIps = x.domainDnsIps
            this.domainFqdn = x.domainFqdn
            this.domainIamRoleName = x.domainIamRoleName
            this.domainOu = x.domainOu
            this.enableCustomerOwnedIp = x.enableCustomerOwnedIp
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.iops = x.iops
            this.licenseModel = x.licenseModel
            this.manageMasterUserPassword = x.manageMasterUserPassword
            this.masterUserPassword = x.masterUserPassword
            this.masterUserSecretKmsKeyId = x.masterUserSecretKmsKeyId
            this.maxAllocatedStorage = x.maxAllocatedStorage
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.multiAz = x.multiAz
            this.multiTenant = x.multiTenant
            this.networkType = x.networkType
            this.newDbInstanceIdentifier = x.newDbInstanceIdentifier
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.processorFeatures = x.processorFeatures
            this.promotionTier = x.promotionTier
            this.publiclyAccessible = x.publiclyAccessible
            this.replicaMode = x.replicaMode
            this.resumeFullAutomationModeMinutes = x.resumeFullAutomationModeMinutes
            this.rotateMasterUserPassword = x.rotateMasterUserPassword
            this.storageThroughput = x.storageThroughput
            this.storageType = x.storageType
            this.tdeCredentialArn = x.tdeCredentialArn
            this.tdeCredentialPassword = x.tdeCredentialPassword
            this.useDefaultProcessorFeatures = x.useDefaultProcessorFeatures
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbInstanceRequest = ModifyDbInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration] inside the given [block]
         */
        public fun cloudwatchLogsExportConfiguration(block: aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.Builder.() -> kotlin.Unit) {
            this.cloudwatchLogsExportConfiguration = aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
