// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class DescribeDbSnapshotTenantDatabasesRequest private constructor(builder: Builder) {
    /**
     * The ID of the DB instance used to create the DB snapshots. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match the identifier of an existing `DBInstance`.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The ID of a DB snapshot that contains the tenant databases to describe. This value is stored as a lowercase string.
     *
     * Constraints:
     * + If you specify this parameter, the value must match the ID of an existing DB snapshot.
     * + If you specify an automatic snapshot, you must also specify `SnapshotType`.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * A specific DB resource identifier to describe.
     */
    public val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * A filter that specifies one or more tenant databases to describe.
     *
     * Supported filters:
     * + `tenant-db-name` - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.
     * + `tenant-database-resource-id` - Tenant database resource identifiers. The results list only includes information about the tenant databases contained within the DB snapshots.
     * + `dbi-resource-id` - DB instance resource identifiers. The results list only includes information about snapshots containing tenant databases contained within the DB instances identified by these resource identifiers.
     * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
     * + `db-snapshot-id` - Accepts DB snapshot identifiers.
     * + `snapshot-type` - Accepts types of DB snapshots.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeDBSnapshotTenantDatabases` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The type of DB snapshots to be returned. You can specify one of the following values:
     * + `automated` – All DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.
     * + `manual` – All DB snapshots that have been taken by my Amazon Web Services account.
     * + `shared` – All manual DB snapshots that have been shared to my Amazon Web Services account.
     * + `public` – All DB snapshots that have been marked as public.
     * + `awsbackup` – All DB snapshots managed by the Amazon Web Services Backup service.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbSnapshotTenantDatabasesRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("snapshotType=$snapshotType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbSnapshotTenantDatabasesRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (snapshotType != other.snapshotType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the DB instance used to create the DB snapshots. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match the identifier of an existing `DBInstance`.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The ID of a DB snapshot that contains the tenant databases to describe. This value is stored as a lowercase string.
         *
         * Constraints:
         * + If you specify this parameter, the value must match the ID of an existing DB snapshot.
         * + If you specify an automatic snapshot, you must also specify `SnapshotType`.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * A specific DB resource identifier to describe.
         */
        public var dbiResourceId: kotlin.String? = null
        /**
         * A filter that specifies one or more tenant databases to describe.
         *
         * Supported filters:
         * + `tenant-db-name` - Tenant database names. The results list only includes information about the tenant databases that match these tenant DB names.
         * + `tenant-database-resource-id` - Tenant database resource identifiers. The results list only includes information about the tenant databases contained within the DB snapshots.
         * + `dbi-resource-id` - DB instance resource identifiers. The results list only includes information about snapshots containing tenant databases contained within the DB instances identified by these resource identifiers.
         * + `db-instance-id` - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).
         * + `db-snapshot-id` - Accepts DB snapshot identifiers.
         * + `snapshot-type` - Accepts types of DB snapshots.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBSnapshotTenantDatabases` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        public var maxRecords: kotlin.Int? = null
        /**
         * The type of DB snapshots to be returned. You can specify one of the following values:
         * + `automated` – All DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.
         * + `manual` – All DB snapshots that have been taken by my Amazon Web Services account.
         * + `shared` – All manual DB snapshots that have been shared to my Amazon Web Services account.
         * + `public` – All DB snapshots that have been marked as public.
         * + `awsbackup` – All DB snapshots managed by the Amazon Web Services Backup service.
         */
        public var snapshotType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.snapshotType = x.snapshotType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbSnapshotTenantDatabasesRequest = DescribeDbSnapshotTenantDatabasesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
