// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeDbRecommendationsRequest private constructor(builder: Builder) {
    /**
     * A filter that specifies one or more recommendations to describe.
     *
     * Supported Filters:
     * + `recommendation-id` - Accepts a list of recommendation identifiers. The results list only includes the recommendations whose identifier is one of the specified filter values.
     * + `status` - Accepts a list of recommendation statuses.Valid values:
     *    + `active` - The recommendations which are ready for you to apply.
     *    + `pending` - The applied or scheduled recommendations which are in progress.
     *    + `resolved` - The recommendations which are completed.
     *    + `dismissed` - The recommendations that you dismissed.
     * The results list only includes the recommendations whose status is one of the specified filter values.
     * + `severity` - Accepts a list of recommendation severities. The results list only includes the recommendations whose severity is one of the specified filter values.Valid values:
     *    + `high`
     *    + `medium`
     *    + `low`
     *    + `informational`
     * + `type-id` - Accepts a list of recommendation type identifiers. The results list only includes the recommendations whose type is one of the specified filter values.
     * + `dbi-resource-id` - Accepts a list of database resource identifiers. The results list only includes the recommendations that generated for the specified databases.
     * + `cluster-resource-id` - Accepts a list of cluster resource identifiers. The results list only includes the recommendations that generated for the specified clusters.
     * + `pg-arn` - Accepts a list of parameter group ARNs. The results list only includes the recommendations that generated for the specified parameter groups.
     * + `cluster-pg-arn` - Accepts a list of cluster parameter group ARNs. The results list only includes the recommendations that generated for the specified cluster parameter groups.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * A filter to include only the recommendations that were updated after this specified time.
     */
    public val lastUpdatedAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAfter
    /**
     * A filter to include only the recommendations that were updated before this specified time.
     */
    public val lastUpdatedBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedBefore
    /**
     * The language that you choose to return the list of recommendations.
     *
     * Valid values:
     * + `en`
     * + `en_UK`
     * + `de`
     * + `es`
     * + `fr`
     * + `id`
     * + `it`
     * + `ja`
     * + `ko`
     * + `pt_BR`
     * + `zh_TW`
     * + `zh_CN`
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * An optional pagination token provided by a previous `DescribeDBRecommendations` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of recommendations to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbRecommendationsRequest(")
        append("filters=$filters,")
        append("lastUpdatedAfter=$lastUpdatedAfter,")
        append("lastUpdatedBefore=$lastUpdatedBefore,")
        append("locale=$locale,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAfter?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedBefore?.hashCode() ?: 0)
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbRecommendationsRequest

        if (filters != other.filters) return false
        if (lastUpdatedAfter != other.lastUpdatedAfter) return false
        if (lastUpdatedBefore != other.lastUpdatedBefore) return false
        if (locale != other.locale) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A filter that specifies one or more recommendations to describe.
         *
         * Supported Filters:
         * + `recommendation-id` - Accepts a list of recommendation identifiers. The results list only includes the recommendations whose identifier is one of the specified filter values.
         * + `status` - Accepts a list of recommendation statuses.Valid values:
         *    + `active` - The recommendations which are ready for you to apply.
         *    + `pending` - The applied or scheduled recommendations which are in progress.
         *    + `resolved` - The recommendations which are completed.
         *    + `dismissed` - The recommendations that you dismissed.
         * The results list only includes the recommendations whose status is one of the specified filter values.
         * + `severity` - Accepts a list of recommendation severities. The results list only includes the recommendations whose severity is one of the specified filter values.Valid values:
         *    + `high`
         *    + `medium`
         *    + `low`
         *    + `informational`
         * + `type-id` - Accepts a list of recommendation type identifiers. The results list only includes the recommendations whose type is one of the specified filter values.
         * + `dbi-resource-id` - Accepts a list of database resource identifiers. The results list only includes the recommendations that generated for the specified databases.
         * + `cluster-resource-id` - Accepts a list of cluster resource identifiers. The results list only includes the recommendations that generated for the specified clusters.
         * + `pg-arn` - Accepts a list of parameter group ARNs. The results list only includes the recommendations that generated for the specified parameter groups.
         * + `cluster-pg-arn` - Accepts a list of cluster parameter group ARNs. The results list only includes the recommendations that generated for the specified cluster parameter groups.
         */
        public var filters: List<Filter>? = null
        /**
         * A filter to include only the recommendations that were updated after this specified time.
         */
        public var lastUpdatedAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A filter to include only the recommendations that were updated before this specified time.
         */
        public var lastUpdatedBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The language that you choose to return the list of recommendations.
         *
         * Valid values:
         * + `en`
         * + `en_UK`
         * + `de`
         * + `es`
         * + `fr`
         * + `id`
         * + `it`
         * + `ja`
         * + `ko`
         * + `pt_BR`
         * + `zh_TW`
         * + `zh_CN`
         */
        public var locale: kotlin.String? = null
        /**
         * An optional pagination token provided by a previous `DescribeDBRecommendations` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of recommendations to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbRecommendationsRequest) : this() {
            this.filters = x.filters
            this.lastUpdatedAfter = x.lastUpdatedAfter
            this.lastUpdatedBefore = x.lastUpdatedBefore
            this.locale = x.locale
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbRecommendationsRequest = DescribeDbRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
