// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class DescribeDbEngineVersionsRequest private constructor(builder: Builder) {
    /**
     * The name of a specific DB parameter group family to return details for.
     *
     * Constraints:
     * + If supplied, must match an existing DB parameter group family.
     */
    public val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * Specifies whether to return only the default version of the specified engine or the engine and major version combination.
     */
    public val defaultOnly: kotlin.Boolean? = builder.defaultOnly
    /**
     * The database engine to return version details for.
     *
     * Valid Values:
     * + `aurora-mysql`
     * + `aurora-postgresql`
     * + `custom-oracle-ee`
     * + `db2-ae`
     * + `db2-se`
     * + `mariadb`
     * + `mysql`
     * + `oracle-ee`
     * + `oracle-ee-cdb`
     * + `oracle-se2`
     * + `oracle-se2-cdb`
     * + `postgres`
     * + `sqlserver-ee`
     * + `sqlserver-se`
     * + `sqlserver-ex`
     * + `sqlserver-web`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * A specific database engine version to return details for.
     *
     * Example: `5.1.49`
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * A filter that specifies one or more DB engine versions to describe.
     *
     * Supported filters:
     * + `db-parameter-group-family` - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.
     * + `engine` - Accepts engine names. The results list only includes information about the DB engine versions for these engines.
     * + `engine-mode` - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:
     *    + `global`
     *    + `multimaster`
     *    + `parallelquery`
     *    + `provisioned`
     *    + `serverless`
     * + `engine-version` - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.
     * + `status` - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:
     *    + `available`
     *    + `deprecated`
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * Specifies whether to also list the engine versions that aren't available. The default is to list only available engine versions.
     */
    public val includeAll: kotlin.Boolean? = builder.includeAll
    /**
     * Specifies whether to list the supported character sets for each engine version.
     *
     * If this parameter is enabled and the requested engine supports the `CharacterSetName` parameter for `CreateDBInstance`, the response includes a list of supported character sets for each engine version.
     *
     * For RDS Custom, the default is not to list supported character sets. If you enable this parameter, RDS Custom returns no results.
     */
    public val listSupportedCharacterSets: kotlin.Boolean? = builder.listSupportedCharacterSets
    /**
     * Specifies whether to list the supported time zones for each engine version.
     *
     * If this parameter is enabled and the requested engine supports the `TimeZone` parameter for `CreateDBInstance`, the response includes a list of supported time zones for each engine version.
     *
     * For RDS Custom, the default is not to list supported time zones. If you enable this parameter, RDS Custom returns no results.
     */
    public val listSupportedTimezones: kotlin.Boolean? = builder.listSupportedTimezones
    /**
     * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more than the `MaxRecords` value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbEngineVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbEngineVersionsRequest(")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("defaultOnly=$defaultOnly,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("filters=$filters,")
        append("includeAll=$includeAll,")
        append("listSupportedCharacterSets=$listSupportedCharacterSets,")
        append("listSupportedTimezones=$listSupportedTimezones,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupFamily?.hashCode() ?: 0
        result = 31 * result + (defaultOnly?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeAll?.hashCode() ?: 0)
        result = 31 * result + (listSupportedCharacterSets?.hashCode() ?: 0)
        result = 31 * result + (listSupportedTimezones?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbEngineVersionsRequest

        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (defaultOnly != other.defaultOnly) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (filters != other.filters) return false
        if (includeAll != other.includeAll) return false
        if (listSupportedCharacterSets != other.listSupportedCharacterSets) return false
        if (listSupportedTimezones != other.listSupportedTimezones) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbEngineVersionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a specific DB parameter group family to return details for.
         *
         * Constraints:
         * + If supplied, must match an existing DB parameter group family.
         */
        public var dbParameterGroupFamily: kotlin.String? = null
        /**
         * Specifies whether to return only the default version of the specified engine or the engine and major version combination.
         */
        public var defaultOnly: kotlin.Boolean? = null
        /**
         * The database engine to return version details for.
         *
         * Valid Values:
         * + `aurora-mysql`
         * + `aurora-postgresql`
         * + `custom-oracle-ee`
         * + `db2-ae`
         * + `db2-se`
         * + `mariadb`
         * + `mysql`
         * + `oracle-ee`
         * + `oracle-ee-cdb`
         * + `oracle-se2`
         * + `oracle-se2-cdb`
         * + `postgres`
         * + `sqlserver-ee`
         * + `sqlserver-se`
         * + `sqlserver-ex`
         * + `sqlserver-web`
         */
        public var engine: kotlin.String? = null
        /**
         * A specific database engine version to return details for.
         *
         * Example: `5.1.49`
         */
        public var engineVersion: kotlin.String? = null
        /**
         * A filter that specifies one or more DB engine versions to describe.
         *
         * Supported filters:
         * + `db-parameter-group-family` - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.
         * + `engine` - Accepts engine names. The results list only includes information about the DB engine versions for these engines.
         * + `engine-mode` - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:
         *    + `global`
         *    + `multimaster`
         *    + `parallelquery`
         *    + `provisioned`
         *    + `serverless`
         * + `engine-version` - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.
         * + `status` - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:
         *    + `available`
         *    + `deprecated`
         */
        public var filters: List<Filter>? = null
        /**
         * Specifies whether to also list the engine versions that aren't available. The default is to list only available engine versions.
         */
        public var includeAll: kotlin.Boolean? = null
        /**
         * Specifies whether to list the supported character sets for each engine version.
         *
         * If this parameter is enabled and the requested engine supports the `CharacterSetName` parameter for `CreateDBInstance`, the response includes a list of supported character sets for each engine version.
         *
         * For RDS Custom, the default is not to list supported character sets. If you enable this parameter, RDS Custom returns no results.
         */
        public var listSupportedCharacterSets: kotlin.Boolean? = null
        /**
         * Specifies whether to list the supported time zones for each engine version.
         *
         * If this parameter is enabled and the requested engine supports the `TimeZone` parameter for `CreateDBInstance`, the response includes a list of supported time zones for each engine version.
         *
         * For RDS Custom, the default is not to list supported time zones. If you enable this parameter, RDS Custom returns no results.
         */
        public var listSupportedTimezones: kotlin.Boolean? = null
        /**
         * An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more than the `MaxRecords` value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbEngineVersionsRequest) : this() {
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.defaultOnly = x.defaultOnly
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.filters = x.filters
            this.includeAll = x.includeAll
            this.listSupportedCharacterSets = x.listSupportedCharacterSets
            this.listSupportedTimezones = x.listSupportedTimezones
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
