// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class DeleteTenantDatabaseRequest private constructor(builder: Builder) {
    /**
     * The user-supplied identifier for the DB instance that contains the tenant database that you want to delete.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The `DBSnapshotIdentifier` of the new `DBSnapshot` created when the `SkipFinalSnapshot` parameter is disabled.
     *
     * If you enable this parameter and also enable `SkipFinalShapshot`, the command results in an error.
     */
    public val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from your DB instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS doesn't skip the final snapshot. If you don't enable this parameter, you must specify the `FinalDBSnapshotIdentifier` parameter.
     */
    public val skipFinalSnapshot: kotlin.Boolean? = builder.skipFinalSnapshot
    /**
     * The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS deletes the tenant database with this name. This parameter isn’t case-sensitive.
     */
    public val tenantDbName: kotlin.String? = builder.tenantDbName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DeleteTenantDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteTenantDatabaseRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot,")
        append("tenantDbName=$tenantDbName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot?.hashCode() ?: 0)
        result = 31 * result + (tenantDbName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteTenantDatabaseRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false
        if (tenantDbName != other.tenantDbName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DeleteTenantDatabaseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user-supplied identifier for the DB instance that contains the tenant database that you want to delete.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The `DBSnapshotIdentifier` of the new `DBSnapshot` created when the `SkipFinalSnapshot` parameter is disabled.
         *
         * If you enable this parameter and also enable `SkipFinalShapshot`, the command results in an error.
         */
        public var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * Specifies whether to skip the creation of a final DB snapshot before removing the tenant database from your DB instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB snapshot before it deletes the tenant database. By default, RDS doesn't skip the final snapshot. If you don't enable this parameter, you must specify the `FinalDBSnapshotIdentifier` parameter.
         */
        public var skipFinalSnapshot: kotlin.Boolean? = null
        /**
         * The user-supplied name of the tenant database that you want to remove from your DB instance. Amazon RDS deletes the tenant database with this name. This parameter isn’t case-sensitive.
         */
        public var tenantDbName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DeleteTenantDatabaseRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
            this.tenantDbName = x.tenantDbName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DeleteTenantDatabaseRequest = DeleteTenantDatabaseRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
