// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details of an Amazon RDS DB subnet group.
 *
 * This data type is used as a response element in the `DescribeDBSubnetGroups` action.
 */
public class DbSubnetGroup private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the DB subnet group.
     */
    public val dbSubnetGroupArn: kotlin.String? = builder.dbSubnetGroupArn
    /**
     * Provides the description of the DB subnet group.
     */
    public val dbSubnetGroupDescription: kotlin.String? = builder.dbSubnetGroupDescription
    /**
     * The name of the DB subnet group.
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Provides the status of the DB subnet group.
     */
    public val subnetGroupStatus: kotlin.String? = builder.subnetGroupStatus
    /**
     * Contains a list of `Subnet` elements.
     */
    public val subnets: List<Subnet>? = builder.subnets
    /**
     * The network type of the DB subnet group.
     *
     * Valid values:
     * + `IPV4`
     * + `DUAL`
     *
     * A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     */
    public val supportedNetworkTypes: List<String>? = builder.supportedNetworkTypes
    /**
     * Provides the VpcId of the DB subnet group.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbSubnetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbSubnetGroup(")
        append("dbSubnetGroupArn=$dbSubnetGroupArn,")
        append("dbSubnetGroupDescription=$dbSubnetGroupDescription,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("subnetGroupStatus=$subnetGroupStatus,")
        append("subnets=$subnets,")
        append("supportedNetworkTypes=$supportedNetworkTypes,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbSubnetGroupArn?.hashCode() ?: 0
        result = 31 * result + (dbSubnetGroupDescription?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (subnetGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (supportedNetworkTypes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbSubnetGroup

        if (dbSubnetGroupArn != other.dbSubnetGroupArn) return false
        if (dbSubnetGroupDescription != other.dbSubnetGroupDescription) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (subnetGroupStatus != other.subnetGroupStatus) return false
        if (subnets != other.subnets) return false
        if (supportedNetworkTypes != other.supportedNetworkTypes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbSubnetGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the DB subnet group.
         */
        public var dbSubnetGroupArn: kotlin.String? = null
        /**
         * Provides the description of the DB subnet group.
         */
        public var dbSubnetGroupDescription: kotlin.String? = null
        /**
         * The name of the DB subnet group.
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Provides the status of the DB subnet group.
         */
        public var subnetGroupStatus: kotlin.String? = null
        /**
         * Contains a list of `Subnet` elements.
         */
        public var subnets: List<Subnet>? = null
        /**
         * The network type of the DB subnet group.
         *
         * Valid values:
         * + `IPV4`
         * + `DUAL`
         *
         * A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         */
        public var supportedNetworkTypes: List<String>? = null
        /**
         * Provides the VpcId of the DB subnet group.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbSubnetGroup) : this() {
            this.dbSubnetGroupArn = x.dbSubnetGroupArn
            this.dbSubnetGroupDescription = x.dbSubnetGroupDescription
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.subnetGroupStatus = x.subnetGroupStatus
            this.subnets = x.subnets
            this.supportedNetworkTypes = x.supportedNetworkTypes
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbSubnetGroup = DbSubnetGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
