// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The recommendation for your DB instances, DB clusters, and DB parameter groups.
 */
public class DbRecommendation private constructor(builder: Builder) {
    /**
     * Additional information about the recommendation. The information might contain markdown.
     */
    public val additionalInfo: kotlin.String? = builder.additionalInfo
    /**
     * The category of the recommendation.
     *
     * Valid values:
     * + `performance efficiency`
     * + `security`
     * + `reliability`
     * + `cost optimization`
     * + `operational excellence`
     * + `sustainability`
     */
    public val category: kotlin.String? = builder.category
    /**
     * The time when the recommendation was created. For example, `2023-09-28T01:13:53.931000+00:00`.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A detailed description of the recommendation. The description might contain markdown.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A short description of the issue identified for this recommendation. The description might contain markdown.
     */
    public val detection: kotlin.String? = builder.detection
    /**
     * A short description that explains the possible impact of an issue.
     */
    public val impact: kotlin.String? = builder.impact
    /**
     * Details of the issue that caused the recommendation.
     */
    public val issueDetails: aws.sdk.kotlin.services.rds.model.IssueDetails? = builder.issueDetails
    /**
     * A link to documentation that provides additional information about the recommendation.
     */
    public val links: List<DocLink>? = builder.links
    /**
     * The reason why this recommendation was created. The information might contain markdown.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * A short description of the recommendation to resolve an issue. The description might contain markdown.
     */
    public val recommendation: kotlin.String? = builder.recommendation
    /**
     * The unique identifier of the recommendation.
     */
    public val recommendationId: kotlin.String? = builder.recommendationId
    /**
     * A list of recommended actions.
     */
    public val recommendedActions: List<RecommendedAction>? = builder.recommendedActions
    /**
     * The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The severity level of the recommendation. The severity level can help you decide the urgency with which to address the recommendation.
     *
     * Valid values:
     * + `high`
     * + `medium`
     * + `low`
     * + `informational`
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The Amazon Web Services service that generated the recommendations.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The current status of the recommendation.
     *
     * Valid values:
     * + `active` - The recommendations which are ready for you to apply.
     * + `pending` - The applied or scheduled recommendations which are in progress.
     * + `resolved` - The recommendations which are completed.
     * + `dismissed` - The recommendations that you dismissed.
     */
    public val status: kotlin.String? = builder.status
    /**
     * A short description of the recommendation type. The description might contain markdown.
     */
    public val typeDetection: kotlin.String? = builder.typeDetection
    /**
     * A value that indicates the type of recommendation. This value determines how the description is rendered.
     */
    public val typeId: kotlin.String? = builder.typeId
    /**
     * A short description that summarizes the recommendation to fix all the issues of the recommendation type. The description might contain markdown.
     */
    public val typeRecommendation: kotlin.String? = builder.typeRecommendation
    /**
     * The time when the recommendation was last updated.
     */
    public val updatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbRecommendation(")
        append("additionalInfo=$additionalInfo,")
        append("category=$category,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("detection=$detection,")
        append("impact=$impact,")
        append("issueDetails=$issueDetails,")
        append("links=$links,")
        append("reason=$reason,")
        append("recommendation=$recommendation,")
        append("recommendationId=$recommendationId,")
        append("recommendedActions=$recommendedActions,")
        append("resourceArn=$resourceArn,")
        append("severity=$severity,")
        append("source=$source,")
        append("status=$status,")
        append("typeDetection=$typeDetection,")
        append("typeId=$typeId,")
        append("typeRecommendation=$typeRecommendation,")
        append("updatedTime=$updatedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (detection?.hashCode() ?: 0)
        result = 31 * result + (impact?.hashCode() ?: 0)
        result = 31 * result + (issueDetails?.hashCode() ?: 0)
        result = 31 * result + (links?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (recommendation?.hashCode() ?: 0)
        result = 31 * result + (recommendationId?.hashCode() ?: 0)
        result = 31 * result + (recommendedActions?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (typeDetection?.hashCode() ?: 0)
        result = 31 * result + (typeId?.hashCode() ?: 0)
        result = 31 * result + (typeRecommendation?.hashCode() ?: 0)
        result = 31 * result + (updatedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbRecommendation

        if (additionalInfo != other.additionalInfo) return false
        if (category != other.category) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (detection != other.detection) return false
        if (impact != other.impact) return false
        if (issueDetails != other.issueDetails) return false
        if (links != other.links) return false
        if (reason != other.reason) return false
        if (recommendation != other.recommendation) return false
        if (recommendationId != other.recommendationId) return false
        if (recommendedActions != other.recommendedActions) return false
        if (resourceArn != other.resourceArn) return false
        if (severity != other.severity) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (typeDetection != other.typeDetection) return false
        if (typeId != other.typeId) return false
        if (typeRecommendation != other.typeRecommendation) return false
        if (updatedTime != other.updatedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Additional information about the recommendation. The information might contain markdown.
         */
        public var additionalInfo: kotlin.String? = null
        /**
         * The category of the recommendation.
         *
         * Valid values:
         * + `performance efficiency`
         * + `security`
         * + `reliability`
         * + `cost optimization`
         * + `operational excellence`
         * + `sustainability`
         */
        public var category: kotlin.String? = null
        /**
         * The time when the recommendation was created. For example, `2023-09-28T01:13:53.931000+00:00`.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A detailed description of the recommendation. The description might contain markdown.
         */
        public var description: kotlin.String? = null
        /**
         * A short description of the issue identified for this recommendation. The description might contain markdown.
         */
        public var detection: kotlin.String? = null
        /**
         * A short description that explains the possible impact of an issue.
         */
        public var impact: kotlin.String? = null
        /**
         * Details of the issue that caused the recommendation.
         */
        public var issueDetails: aws.sdk.kotlin.services.rds.model.IssueDetails? = null
        /**
         * A link to documentation that provides additional information about the recommendation.
         */
        public var links: List<DocLink>? = null
        /**
         * The reason why this recommendation was created. The information might contain markdown.
         */
        public var reason: kotlin.String? = null
        /**
         * A short description of the recommendation to resolve an issue. The description might contain markdown.
         */
        public var recommendation: kotlin.String? = null
        /**
         * The unique identifier of the recommendation.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * A list of recommended actions.
         */
        public var recommendedActions: List<RecommendedAction>? = null
        /**
         * The Amazon Resource Name (ARN) of the RDS resource associated with the recommendation.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The severity level of the recommendation. The severity level can help you decide the urgency with which to address the recommendation.
         *
         * Valid values:
         * + `high`
         * + `medium`
         * + `low`
         * + `informational`
         */
        public var severity: kotlin.String? = null
        /**
         * The Amazon Web Services service that generated the recommendations.
         */
        public var source: kotlin.String? = null
        /**
         * The current status of the recommendation.
         *
         * Valid values:
         * + `active` - The recommendations which are ready for you to apply.
         * + `pending` - The applied or scheduled recommendations which are in progress.
         * + `resolved` - The recommendations which are completed.
         * + `dismissed` - The recommendations that you dismissed.
         */
        public var status: kotlin.String? = null
        /**
         * A short description of the recommendation type. The description might contain markdown.
         */
        public var typeDetection: kotlin.String? = null
        /**
         * A value that indicates the type of recommendation. This value determines how the description is rendered.
         */
        public var typeId: kotlin.String? = null
        /**
         * A short description that summarizes the recommendation to fix all the issues of the recommendation type. The description might contain markdown.
         */
        public var typeRecommendation: kotlin.String? = null
        /**
         * The time when the recommendation was last updated.
         */
        public var updatedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbRecommendation) : this() {
            this.additionalInfo = x.additionalInfo
            this.category = x.category
            this.createdTime = x.createdTime
            this.description = x.description
            this.detection = x.detection
            this.impact = x.impact
            this.issueDetails = x.issueDetails
            this.links = x.links
            this.reason = x.reason
            this.recommendation = x.recommendation
            this.recommendationId = x.recommendationId
            this.recommendedActions = x.recommendedActions
            this.resourceArn = x.resourceArn
            this.severity = x.severity
            this.source = x.source
            this.status = x.status
            this.typeDetection = x.typeDetection
            this.typeId = x.typeId
            this.typeRecommendation = x.typeRecommendation
            this.updatedTime = x.updatedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbRecommendation = DbRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.IssueDetails] inside the given [block]
         */
        public fun issueDetails(block: aws.sdk.kotlin.services.rds.model.IssueDetails.Builder.() -> kotlin.Unit) {
            this.issueDetails = aws.sdk.kotlin.services.rds.model.IssueDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
