// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class CreateDbClusterRequest private constructor(builder: Builder) {
    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * This setting is required to create a Multi-AZ DB cluster.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
     *
     * For information on Amazon Web Services Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to `0`.
     *
     * Valid for Cluster Type: Aurora MySQL DB clusters only
     *
     * Default: `0`
     *
     * Constraints:
     * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     */
    public val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automated backups are retained.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Default: `1`
     *
     * Constraints:
     * + Must be a value from 1 to 35.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The name of the character set (`CharacterSet`) to associate the DB cluster with.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The identifier for this DB cluster. This parameter is stored as a lowercase string.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must contain from 1 to 63 (for Aurora DB clusters) or 1 to 52 (for Multi-AZ DB clusters) letters, numbers, or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster1`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     *
     * For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
     *
     * This setting is required to create a Multi-AZ DB cluster.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + If supplied, must match the name of an existing DB cluster parameter group.
     */
    public val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * A DB subnet group to associate with this DB cluster.
     *
     * This setting is required to create a Multi-AZ DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must match the name of an existing DB subnet group.
     * + Must not be `default`.
     *
     * Example: `mydbsubnetgroup`
     */
    public val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * Reserved for future use.
     */
    public val dbSystemId: kotlin.String? = builder.dbSystemId
    /**
     * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to create the DB cluster in.
     *
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
     *
     * For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The name of the IAM role to use when making API calls to the Directory Service.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * The following values are valid for each DB engine:
     * + Aurora MySQL - `audit | error | general | slowquery`
     * + Aurora PostgreSQL - `postgresql`
     * + RDS for MySQL - `error | general | slowquery`
     * + RDS for PostgreSQL - `postgresql | upgrade`
     *
     * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
     *
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
     */
    public val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
     *
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableGlobalWriteForwarding: kotlin.Boolean? = builder.enableGlobalWriteForwarding
    /**
     * Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
     *
     * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
     *
     * RDS Data API is supported with the following DB clusters:
     * + Aurora PostgreSQL Serverless v2 and provisioned
     * + Aurora PostgreSQL and Aurora MySQL Serverless v1
     *
     * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableHttpEndpoint: kotlin.Boolean? = builder.enableHttpEndpoint
    /**
     * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
     *
     * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableLimitlessDatabase: kotlin.Boolean? = builder.enableLimitlessDatabase
    /**
     * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
     *
     * Valid for: Aurora DB clusters only
     */
    public val enableLocalWriteForwarding: kotlin.Boolean? = builder.enableLocalWriteForwarding
    /**
     * Specifies whether to turn on Performance Insights for the DB cluster.
     *
     * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The database engine to use for this DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Valid Values: `aurora-mysql | aurora-postgresql | mysql | postgres`
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
     *
     * The `serverless` engine mode only applies for Aurora Serverless v1 DB clusters.
     *
     * For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
     * + [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations)
     * + [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html)
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version number of the database engine to use.
     *
     * To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL 8.0-compatible), use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * You can supply either `5.7` or `8.0` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
     *
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
     *
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *
     * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
     *
     * For information about a specific engine, see the following topics:
     * + Aurora MySQL - see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
     * + Aurora PostgreSQL - see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
     * + RDS for MySQL - see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
     * + RDS for PostgreSQL - see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
     *
     * For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
     *
     * This setting is required to create a Multi-AZ DB cluster.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Constraints:
     * + Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * When a KMS key isn't specified in `KmsKeyId`:
     * + If `ReplicationSourceIdentifier` identifies an encrypted source, then Amazon RDS uses the KMS key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
     * + If the `StorageEncrypted` parameter is enabled and `ReplicationSourceIdentifier` isn't specified, then Amazon RDS uses your default KMS key.
     *
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure to set `KmsKeyId` to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
     *
     * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Can't manage the master user password with Amazon Web Services Secrets Manager if `MasterUserPassword` is specified.
     */
    public val manageMasterUserPassword: kotlin.Boolean? = builder.manageMasterUserPassword
    /**
     * The password for the master database user.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must contain from 8 to 41 characters.
     * + Can contain any printable ASCII character except "/", """, or "@".
     * + Can't be specified if `ManageMasterUserPassword` is turned on.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
     *
     * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     *
     * If you don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
     *
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val masterUserSecretKmsKeyId: kotlin.String? = builder.masterUserSecretKmsKeyId
    /**
     * The name of the master user for the DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Constraints:
     * + Must be 1 to 16 letters or numbers.
     * + First character must be a letter.
     * + Can't be a reserved word for the chosen database engine.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify `0`.
     *
     * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than `0`.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
     *
     * Default: `0`
     */
    public val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
     *
     * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * The network type of the DB cluster.
     *
     * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
     *
     * Valid for Cluster Type: Aurora DB clusters only
     *
     * Valid Values: `IPV4 | DUAL`
     */
    public val networkType: kotlin.String? = builder.networkType
    /**
     * The option group to associate the DB cluster with.
     *
     * DB clusters are associated with a default option group that can't be modified.
     */
    public val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     *
     * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     */
    public val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The number of days to retain Performance Insights data.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Valid Values:
     * + `7`
     * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
     * + `731`
     *
     * Default: `7` days
     *
     * If you specify a retention period that isn't valid, such as `94`, Amazon RDS issues an error.
     */
    public val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number on which the instances in the DB cluster accept connections.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Valid Values: `1150-65535`
     *
     * Default:
     * + RDS for MySQL and Aurora MySQL - `3306`
     * + RDS for PostgreSQL and Aurora PostgreSQL - `5432`
     */
    public val port: kotlin.Int? = builder.port
    /**
     * When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an URL that contains a Signature Version 4 signed request for the `CreateDBCluster` operation to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify `PreSignedUrl` only when you are performing cross-Region replication from an encrypted DB cluster.
     *
     * The presigned URL must be a valid request for the `CreateDBCluster` API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster to copy.
     *
     * The presigned URL request must contain the following parameter values:
     * + `KmsKeyId` - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the `CreateDBCluster` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
     * + `DestinationRegion` - The name of the Amazon Web Services Region that Aurora read replica will be created in.
     * + `ReplicationSourceIdentifier` - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your `ReplicationSourceIdentifier` would look like Example: `arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`.
     *
     * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
     *
     * Constraints:
     * + Must be in the format `hh24:mi-hh24:mi`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
     *
     * Constraints:
     * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
     * + Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
     * + Must be in Universal Coordinated Time (UTC).
     * + Must be at least 30 minutes.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies whether the DB cluster is publicly accessible.
     *
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
     *
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     *
     * Valid for Cluster Type: Multi-AZ DB clusters only
     *
     * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
     *
     * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *
     * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
     * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * Reserved for future use.
     */
    public val rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = builder.rdsCustomClusterConfiguration
    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters only
     */
    public val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     *
     * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
     */
    public val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * Specifies whether the DB cluster is encrypted.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * The storage type to associate with the DB cluster.
     *
     * For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
     *
     * This setting is required to create a Multi-AZ DB cluster.
     *
     * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     *
     * Valid Values:
     * + Aurora DB clusters - `aurora | aurora-iopt1`
     * + Multi-AZ DB clusters - `io1`
     *
     * Default:
     * + Aurora DB clusters - `aurora`
     * + Multi-AZ DB clusters - `io1`
     *
     * When you create an Aurora DB cluster with the storage type set to `aurora-iopt1`, the storage type is returned in the response. The storage type isn't returned when you set it to `aurora`.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * Tags to assign to the DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     *
     * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZones=$availabilityZones,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("dbSystemId=$dbSystemId,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableGlobalWriteForwarding=$enableGlobalWriteForwarding,")
        append("enableHttpEndpoint=$enableHttpEndpoint,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enableLimitlessDatabase=$enableLimitlessDatabase,")
        append("enableLocalWriteForwarding=$enableLocalWriteForwarding,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("manageMasterUserPassword=$manageMasterUserPassword,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUserSecretKmsKeyId=$masterUserSecretKmsKeyId,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("networkType=$networkType,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preSignedUrl=$preSignedUrl,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("rdsCustomClusterConfiguration=$rdsCustomClusterConfiguration,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSystemId?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableGlobalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enableHttpEndpoint?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enableLimitlessDatabase?.hashCode() ?: 0)
        result = 31 * result + (enableLocalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (manageMasterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUserSecretKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (networkType?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (rdsCustomClusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbClusterRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (dbSystemId != other.dbSystemId) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableGlobalWriteForwarding != other.enableGlobalWriteForwarding) return false
        if (enableHttpEndpoint != other.enableHttpEndpoint) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enableLimitlessDatabase != other.enableLimitlessDatabase) return false
        if (enableLocalWriteForwarding != other.enableLocalWriteForwarding) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (manageMasterUserPassword != other.manageMasterUserPassword) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUserSecretKmsKeyId != other.masterUserSecretKmsKeyId) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (networkType != other.networkType) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (rdsCustomClusterConfiguration != other.rdsCustomClusterConfiguration) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * This setting is required to create a Multi-AZ DB cluster.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * Specifies whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
         *
         * For information on Amazon Web Services Regions and Availability Zones, see [Choosing the Regions and Availability Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var availabilityZones: List<String>? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to `0`.
         *
         * Valid for Cluster Type: Aurora MySQL DB clusters only
         *
         * Default: `0`
         *
         * Constraints:
         * + If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         */
        public var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automated backups are retained.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Default: `1`
         *
         * Constraints:
         * + Must be a value from 1 to 35.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The name of the character set (`CharacterSet`) to associate the DB cluster with.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var characterSetName: kotlin.String? = null
        /**
         * Specifies whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The name for your database of up to 64 alphanumeric characters. If you don't provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var databaseName: kotlin.String? = null
        /**
         * The identifier for this DB cluster. This parameter is stored as a lowercase string.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must contain from 1 to 63 (for Aurora DB clusters) or 1 to 52 (for Multi-AZ DB clusters) letters, numbers, or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster1`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example `db.m6gd.xlarge`. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         *
         * For the full list of DB instance classes and availability for your engine, see [DB instance class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html) in the *Amazon RDS User Guide*.
         *
         * This setting is required to create a Multi-AZ DB cluster.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate with this DB cluster. If you don't specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + If supplied, must match the name of an existing DB cluster parameter group.
         */
        public var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * A DB subnet group to associate with this DB cluster.
         *
         * This setting is required to create a Multi-AZ DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must match the name of an existing DB subnet group.
         * + Must not be `default`.
         *
         * Example: `mydbsubnetgroup`
         */
        public var dbSubnetGroupName: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var dbSystemId: kotlin.String? = null
        /**
         * Specifies whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to create the DB cluster in.
         *
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         *
         * For more information, see [Kerberos authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var domain: kotlin.String? = null
        /**
         * The name of the IAM role to use when making API calls to the Directory Service.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var domainIamRoleName: kotlin.String? = null
        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * The following values are valid for each DB engine:
         * + Aurora MySQL - `audit | error | general | slowquery`
         * + Aurora PostgreSQL - `postgresql`
         * + RDS for MySQL - `error | general | slowquery`
         * + RDS for PostgreSQL - `postgresql | upgrade`
         *
         * For more information about exporting CloudWatch Logs for Amazon RDS, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon RDS User Guide*.
         *
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see [Publishing Database Logs to Amazon CloudWatch Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch) in the *Amazon Aurora User Guide*.
         */
        public var enableCloudwatchLogsExports: List<String>? = null
        /**
         * Specifies whether to enable this DB cluster to forward write operations to the primary cluster of a global cluster (Aurora global database). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.
         *
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster, and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by a global cluster API operation, but it does nothing until then.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableGlobalWriteForwarding: kotlin.Boolean? = null
        /**
         * Specifies whether to enable the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
         *
         * When enabled, the HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL queries on the DB cluster. You can also query your database from inside the RDS console with the RDS query editor.
         *
         * RDS Data API is supported with the following DB clusters:
         * + Aurora PostgreSQL Serverless v2 and provisioned
         * + Aurora PostgreSQL and Aurora MySQL Serverless v1
         *
         * For more information, see [Using RDS Data API](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableHttpEndpoint: kotlin.Boolean? = null
        /**
         * Specifies whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.
         *
         * For more information, see [ IAM Database Authentication](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html) in the *Amazon Aurora User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * Specifies whether to enable Aurora Limitless Database. You must enable Aurora Limitless Database to create a DB shard group.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableLimitlessDatabase: kotlin.Boolean? = null
        /**
         * Specifies whether read replicas can forward write operations to the writer DB instance in the DB cluster. By default, write operations aren't allowed on reader DB instances.
         *
         * Valid for: Aurora DB clusters only
         */
        public var enableLocalWriteForwarding: kotlin.Boolean? = null
        /**
         * Specifies whether to turn on Performance Insights for the DB cluster.
         *
         * For more information, see [ Using Amazon Performance Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The database engine to use for this DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Valid Values: `aurora-mysql | aurora-postgresql | mysql | postgres`
         */
        public var engine: kotlin.String? = null
        /**
         * The DB engine mode of the DB cluster, either `provisioned` or `serverless`.
         *
         * The `serverless` engine mode only applies for Aurora Serverless v1 DB clusters.
         *
         * For information about limitations and requirements for Serverless DB clusters, see the following sections in the *Amazon Aurora User Guide*:
         * + [Limitations of Aurora Serverless v1](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations)
         * + [Requirements for Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.requirements.html)
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var engineMode: kotlin.String? = null
        /**
         * The version number of the database engine to use.
         *
         * To list all of the available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL 8.0-compatible), use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * You can supply either `5.7` or `8.0` to use the default engine version for Aurora MySQL version 2 or version 3, respectively.
         *
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"`
         *
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *
         * `aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"`
         *
         * For information about a specific engine, see the following topics:
         * + Aurora MySQL - see [Database engine updates for Amazon Aurora MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html) in the *Amazon Aurora User Guide*.
         * + Aurora PostgreSQL - see [Amazon Aurora PostgreSQL releases and engine versions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html) in the *Amazon Aurora User Guide*.
         * + RDS for MySQL - see [Amazon RDS for MySQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt) in the *Amazon RDS User Guide*.
         * + RDS for PostgreSQL - see [Amazon RDS for PostgreSQL](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts) in the *Amazon RDS User Guide*.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.
         *
         * For information about valid IOPS values, see [Provisioned IOPS storage](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS) in the *Amazon RDS User Guide*.
         *
         * This setting is required to create a Multi-AZ DB cluster.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Constraints:
         * + Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         */
        public var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * When a KMS key isn't specified in `KmsKeyId`:
         * + If `ReplicationSourceIdentifier` identifies an encrypted source, then Amazon RDS uses the KMS key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.
         * + If the `StorageEncrypted` parameter is enabled and `ReplicationSourceIdentifier` isn't specified, then Amazon RDS uses your default KMS key.
         *
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, make sure to set `KmsKeyId` to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Specifies whether to manage the master user password with Amazon Web Services Secrets Manager.
         *
         * For more information, see [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html) in the *Amazon RDS User Guide* and [Password management with Amazon Web Services Secrets Manager](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-secrets-manager.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Can't manage the master user password with Amazon Web Services Secrets Manager if `MasterUserPassword` is specified.
         */
        public var manageMasterUserPassword: kotlin.Boolean? = null
        /**
         * The password for the master database user.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must contain from 8 to 41 characters.
         * + Can contain any printable ASCII character except "/", """, or "@".
         * + Can't be specified if `ManageMasterUserPassword` is turned on.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier to encrypt a secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
         *
         * This setting is valid only if the master user password is managed by RDS in Amazon Web Services Secrets Manager for the DB cluster.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         *
         * If you don't specify `MasterUserSecretKmsKeyId`, then the `aws/secretsmanager` KMS key is used to encrypt the secret. If the secret is in a different Amazon Web Services account, then you can't use the `aws/secretsmanager` KMS key to encrypt the secret, and you must use a customer managed KMS key.
         *
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var masterUserSecretKmsKeyId: kotlin.String? = null
        /**
         * The name of the master user for the DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Constraints:
         * + Must be 1 to 16 letters or numbers.
         * + First character must be a letter.
         * + Can't be a reserved word for the chosen database engine.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify `0`.
         *
         * If `MonitoringRoleArn` is specified, also set `MonitoringInterval` to a value other than `0`.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Valid Values: `0 | 1 | 5 | 10 | 15 | 30 | 60`
         *
         * Default: `0`
         */
        public var monitoringInterval: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is `arn:aws:iam:123456789012:role/emaccess`. For information on creating a monitoring role, see [Setting up and enabling Enhanced Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling) in the *Amazon RDS User Guide*.
         *
         * If `MonitoringInterval` is set to a value other than `0`, supply a `MonitoringRoleArn` value.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var monitoringRoleArn: kotlin.String? = null
        /**
         * The network type of the DB cluster.
         *
         * The network type is determined by the `DBSubnetGroup` specified for the DB cluster. A `DBSubnetGroup` can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon Aurora User Guide.*
         *
         * Valid for Cluster Type: Aurora DB clusters only
         *
         * Valid Values: `IPV4 | DUAL`
         */
        public var networkType: kotlin.String? = null
        /**
         * The option group to associate the DB cluster with.
         *
         * DB clusters are associated with a default option group that can't be modified.
         */
        public var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         *
         * If you don't specify a value for `PerformanceInsightsKMSKeyId`, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         */
        public var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The number of days to retain Performance Insights data.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Valid Values:
         * + `7`
         * + *month* * 31, where *month* is a number of months from 1-23. Examples: `93` (3 months * 31), `341` (11 months * 31), `589` (19 months * 31)
         * + `731`
         *
         * Default: `7` days
         *
         * If you specify a retention period that isn't valid, such as `94`, Amazon RDS issues an error.
         */
        public var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number on which the instances in the DB cluster accept connections.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Valid Values: `1150-65535`
         *
         * Default:
         * + RDS for MySQL and Aurora MySQL - `3306`
         * + RDS for PostgreSQL and Aurora PostgreSQL - `5432`
         */
        public var port: kotlin.Int? = null
        /**
         * When you are replicating a DB cluster from one Amazon Web Services GovCloud (US) Region to another, an URL that contains a Signature Version 4 signed request for the `CreateDBCluster` operation to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify `PreSignedUrl` only when you are performing cross-Region replication from an encrypted DB cluster.
         *
         * The presigned URL must be a valid request for the `CreateDBCluster` API operation that can run in the source Amazon Web Services Region that contains the encrypted DB cluster to copy.
         *
         * The presigned URL request must contain the following parameter values:
         * + `KmsKeyId` - The KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the `CreateDBCluster` operation that is called in the destination Amazon Web Services Region, and the operation contained in the presigned URL.
         * + `DestinationRegion` - The name of the Amazon Web Services Region that Aurora read replica will be created in.
         * + `ReplicationSourceIdentifier` - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your `ReplicationSourceIdentifier` would look like Example: `arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`.
         *
         * To learn how to generate a Signature Version 4 signed request, see [ Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html) and [ Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify `SourceRegion` (or `--source-region` for the CLI) instead of specifying `PreSignedUrl` manually. Specifying `SourceRegion` autogenerates a presigned URL that is a valid request for the operation that can run in the source Amazon Web Services Region.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var preSignedUrl: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created if automated backups are enabled using the `BackupRetentionPeriod` parameter.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see [ Backup window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow) in the *Amazon Aurora User Guide*.
         *
         * Constraints:
         * + Must be in the format `hh24:mi-hh24:mi`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see [ Adjusting the Preferred DB Cluster Maintenance Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora) in the *Amazon Aurora User Guide*.
         *
         * Constraints:
         * + Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
         * + Days must be one of `Mon | Tue | Wed | Thu | Fri | Sat | Sun`.
         * + Must be in Universal Coordinated Time (UTC).
         * + Must be at least 30 minutes.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies whether the DB cluster is publicly accessible.
         *
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.
         *
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         *
         * Valid for Cluster Type: Multi-AZ DB clusters only
         *
         * Default: The default behavior varies depending on whether `DBSubnetGroupName` is specified.
         *
         * If `DBSubnetGroupName` isn't specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         *
         * If `DBSubnetGroupName` is specified, and `PubliclyAccessible` isn't specified, the following applies:
         * + If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
         * + If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * Reserved for future use.
         */
        public var rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var replicationSourceIdentifier: kotlin.String? = null
        /**
         * For DB clusters in `serverless` DB engine mode, the scaling properties of the DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters only
         */
        public var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         *
         * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
         */
        public var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * Specifies whether the DB cluster is encrypted.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var storageEncrypted: kotlin.Boolean? = null
        /**
         * The storage type to associate with the DB cluster.
         *
         * For information on storage types for Aurora DB clusters, see [Storage configurations for Amazon Aurora DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Overview.StorageReliability.html#aurora-storage-type). For information on storage types for Multi-AZ DB clusters, see [Settings for creating Multi-AZ DB clusters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/create-multi-az-db-cluster.html#create-multi-az-db-cluster-settings).
         *
         * This setting is required to create a Multi-AZ DB cluster.
         *
         * When specified for a Multi-AZ DB cluster, a value for the `Iops` parameter is required.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         *
         * Valid Values:
         * + Aurora DB clusters - `aurora | aurora-iopt1`
         * + Multi-AZ DB clusters - `io1`
         *
         * Default:
         * + Aurora DB clusters - `aurora`
         * + Multi-AZ DB clusters - `io1`
         *
         * When you create an Aurora DB cluster with the storage type set to `aurora-iopt1`, the storage type is returned in the response. The storage type isn't returned when you set it to `aurora`.
         */
        public var storageType: kotlin.String? = null
        /**
         * Tags to assign to the DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var tags: List<Tag>? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         *
         * Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
         */
        public var vpcSecurityGroupIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZones = x.availabilityZones
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.dbSystemId = x.dbSystemId
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableGlobalWriteForwarding = x.enableGlobalWriteForwarding
            this.enableHttpEndpoint = x.enableHttpEndpoint
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enableLimitlessDatabase = x.enableLimitlessDatabase
            this.enableLocalWriteForwarding = x.enableLocalWriteForwarding
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.manageMasterUserPassword = x.manageMasterUserPassword
            this.masterUserPassword = x.masterUserPassword
            this.masterUserSecretKmsKeyId = x.masterUserSecretKmsKeyId
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.networkType = x.networkType
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preSignedUrl = x.preSignedUrl
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.rdsCustomClusterConfiguration = x.rdsCustomClusterConfiguration
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = CreateDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration] inside the given [block]
         */
        public fun rdsCustomClusterConfiguration(block: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.rdsCustomClusterConfiguration = aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        public fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        public fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
