// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Specifies the settings that control the size and behavior of the connection pool associated with a `DBProxyTargetGroup`.
 */
public class ConnectionPoolConfiguration private constructor(builder: Builder) {
    /**
     * The number of seconds for a proxy to wait for a connection to become available in the connection pool. This setting only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions. For an unlimited wait time, specify `0`.
     *
     * Default: `120`
     *
     * Constraints:
     * + Must be between 0 and 3600.
     */
    public val connectionBorrowTimeout: kotlin.Int? = builder.connectionBorrowTimeout
    /**
     * One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
     *
     * Default: no initialization query
     */
    public val initQuery: kotlin.String? = builder.initQuery
    /**
     * The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the `max_connections` setting for the RDS DB instance or Aurora DB cluster used by the target group.
     *
     * If you specify `MaxIdleConnectionsPercent`, then you must also include a value for this parameter.
     *
     * Default: `10` for RDS for Microsoft SQL Server, and `100` for all other engines
     *
     * Constraints:
     * + Must be between 1 and 100.
     */
    public val maxConnectionsPercent: kotlin.Int? = builder.maxConnectionsPercent
    /**
     * A value that controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the `max_connections` setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
     *
     * If you specify this parameter, then you must also include a value for `MaxConnectionsPercent`.
     *
     * Default: The default value is half of the value of `MaxConnectionsPercent`. For example, if `MaxConnectionsPercent` is 80, then the default value of `MaxIdleConnectionsPercent` is 40. If the value of `MaxConnectionsPercent` isn't specified, then for SQL Server, `MaxIdleConnectionsPercent` is `5`, and for all other engines, the default is `50`.
     *
     * Constraints:
     * + Must be between 0 and the value of `MaxConnectionsPercent`.
     */
    public val maxIdleConnectionsPercent: kotlin.Int? = builder.maxIdleConnectionsPercent
    /**
     * Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.
     *
     * Default: no session pinning filters
     */
    public val sessionPinningFilters: List<String>? = builder.sessionPinningFilters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ConnectionPoolConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectionPoolConfiguration(")
        append("connectionBorrowTimeout=$connectionBorrowTimeout,")
        append("initQuery=$initQuery,")
        append("maxConnectionsPercent=$maxConnectionsPercent,")
        append("maxIdleConnectionsPercent=$maxIdleConnectionsPercent,")
        append("sessionPinningFilters=$sessionPinningFilters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionBorrowTimeout ?: 0
        result = 31 * result + (initQuery?.hashCode() ?: 0)
        result = 31 * result + (maxConnectionsPercent ?: 0)
        result = 31 * result + (maxIdleConnectionsPercent ?: 0)
        result = 31 * result + (sessionPinningFilters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectionPoolConfiguration

        if (connectionBorrowTimeout != other.connectionBorrowTimeout) return false
        if (initQuery != other.initQuery) return false
        if (maxConnectionsPercent != other.maxConnectionsPercent) return false
        if (maxIdleConnectionsPercent != other.maxIdleConnectionsPercent) return false
        if (sessionPinningFilters != other.sessionPinningFilters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ConnectionPoolConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of seconds for a proxy to wait for a connection to become available in the connection pool. This setting only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions. For an unlimited wait time, specify `0`.
         *
         * Default: `120`
         *
         * Constraints:
         * + Must be between 0 and 3600.
         */
        public var connectionBorrowTimeout: kotlin.Int? = null
        /**
         * One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
         *
         * Default: no initialization query
         */
        public var initQuery: kotlin.String? = null
        /**
         * The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the `max_connections` setting for the RDS DB instance or Aurora DB cluster used by the target group.
         *
         * If you specify `MaxIdleConnectionsPercent`, then you must also include a value for this parameter.
         *
         * Default: `10` for RDS for Microsoft SQL Server, and `100` for all other engines
         *
         * Constraints:
         * + Must be between 1 and 100.
         */
        public var maxConnectionsPercent: kotlin.Int? = null
        /**
         * A value that controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the `max_connections` setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database.
         *
         * If you specify this parameter, then you must also include a value for `MaxConnectionsPercent`.
         *
         * Default: The default value is half of the value of `MaxConnectionsPercent`. For example, if `MaxConnectionsPercent` is 80, then the default value of `MaxIdleConnectionsPercent` is 40. If the value of `MaxConnectionsPercent` isn't specified, then for SQL Server, `MaxIdleConnectionsPercent` is `5`, and for all other engines, the default is `50`.
         *
         * Constraints:
         * + Must be between 0 and the value of `MaxConnectionsPercent`.
         */
        public var maxIdleConnectionsPercent: kotlin.Int? = null
        /**
         * Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.
         *
         * Default: no session pinning filters
         */
        public var sessionPinningFilters: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ConnectionPoolConfiguration) : this() {
            this.connectionBorrowTimeout = x.connectionBorrowTimeout
            this.initQuery = x.initQuery
            this.maxConnectionsPercent = x.maxConnectionsPercent
            this.maxIdleConnectionsPercent = x.maxIdleConnectionsPercent
            this.sessionPinningFilters = x.sessionPinningFilters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ConnectionPoolConfiguration = ConnectionPoolConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
