// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * This data type is used as a response element in the `ModifyDBCluster` operation and contains changes that will be applied during the next maintenance window.
 */
public class ClusterPendingModifiedValues private constructor(builder: Builder) {
    /**
     * The allocated storage size in gibibytes (GiB) for all database engines except Amazon Aurora. For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
     */
    public val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * The number of days for which automatic DB snapshots are retained.
     */
    public val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * The DBClusterIdentifier value for the DB cluster.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The database engine version.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean? = builder.iamDatabaseAuthenticationEnabled
    /**
     * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.
     */
    public val iops: kotlin.Int? = builder.iops
    /**
     * The master credentials for the DB cluster.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.
     */
    public val pendingCloudwatchLogsExports: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports? = builder.pendingCloudwatchLogsExports
    /**
     * Reserved for future use.
     */
    public val rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = builder.rdsCustomClusterConfiguration
    /**
     * The storage type for the DB cluster.
     */
    public val storageType: kotlin.String? = builder.storageType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClusterPendingModifiedValues(")
        append("allocatedStorage=$allocatedStorage,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("iops=$iops,")
        append("masterUserPassword=$masterUserPassword,")
        append("pendingCloudwatchLogsExports=$pendingCloudwatchLogsExports,")
        append("rdsCustomClusterConfiguration=$rdsCustomClusterConfiguration,")
        append("storageType=$storageType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (pendingCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (rdsCustomClusterConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClusterPendingModifiedValues

        if (allocatedStorage != other.allocatedStorage) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (iops != other.iops) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (pendingCloudwatchLogsExports != other.pendingCloudwatchLogsExports) return false
        if (rdsCustomClusterConfiguration != other.rdsCustomClusterConfiguration) return false
        if (storageType != other.storageType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The allocated storage size in gibibytes (GiB) for all database engines except Amazon Aurora. For Aurora, `AllocatedStorage` always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.
         */
        public var allocatedStorage: kotlin.Int? = null
        /**
         * The number of days for which automatic DB snapshots are retained.
         */
        public var backupRetentionPeriod: kotlin.Int? = null
        /**
         * The DBClusterIdentifier value for the DB cluster.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The database engine version.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean? = null
        /**
         * The Provisioned IOPS (I/O operations per second) value. This setting is only for non-Aurora Multi-AZ DB clusters.
         */
        public var iops: kotlin.Int? = null
        /**
         * The master credentials for the DB cluster.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.
         */
        public var pendingCloudwatchLogsExports: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports? = null
        /**
         * Reserved for future use.
         */
        public var rdsCustomClusterConfiguration: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration? = null
        /**
         * The storage type for the DB cluster.
         */
        public var storageType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.iops = x.iops
            this.masterUserPassword = x.masterUserPassword
            this.pendingCloudwatchLogsExports = x.pendingCloudwatchLogsExports
            this.rdsCustomClusterConfiguration = x.rdsCustomClusterConfiguration
            this.storageType = x.storageType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ClusterPendingModifiedValues = ClusterPendingModifiedValues(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports] inside the given [block]
         */
        public fun pendingCloudwatchLogsExports(block: aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports.Builder.() -> kotlin.Unit) {
            this.pendingCloudwatchLogsExports = aws.sdk.kotlin.services.rds.model.PendingCloudwatchLogsExports.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration] inside the given [block]
         */
        public fun rdsCustomClusterConfiguration(block: aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.rdsCustomClusterConfiguration = aws.sdk.kotlin.services.rds.model.RdsCustomClusterConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
