// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A CA certificate for an Amazon Web Services account.
 *
 * For more information, see [Using SSL/TLS to encrypt a connection to a DB instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html) in the *Amazon RDS User Guide* and [ Using SSL/TLS to encrypt a connection to a DB cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html) in the *Amazon Aurora User Guide*.
 */
public class Certificate private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the certificate.
     */
    public val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The unique key that identifies a certificate.
     */
    public val certificateIdentifier: kotlin.String? = builder.certificateIdentifier
    /**
     * The type of the certificate.
     */
    public val certificateType: kotlin.String? = builder.certificateType
    /**
     * Indicates whether there is an override for the default certificate identifier.
     */
    public val customerOverride: kotlin.Boolean? = builder.customerOverride
    /**
     * If there is an override for the default certificate identifier, when the override expires.
     */
    public val customerOverrideValidTill: aws.smithy.kotlin.runtime.time.Instant? = builder.customerOverrideValidTill
    /**
     * The thumbprint of the certificate.
     */
    public val thumbprint: kotlin.String? = builder.thumbprint
    /**
     * The starting date from which the certificate is valid.
     */
    public val validFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.validFrom
    /**
     * The final date that the certificate continues to be valid.
     */
    public val validTill: aws.smithy.kotlin.runtime.time.Instant? = builder.validTill

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.Certificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Certificate(")
        append("certificateArn=$certificateArn,")
        append("certificateIdentifier=$certificateIdentifier,")
        append("certificateType=$certificateType,")
        append("customerOverride=$customerOverride,")
        append("customerOverrideValidTill=$customerOverrideValidTill,")
        append("thumbprint=$thumbprint,")
        append("validFrom=$validFrom,")
        append("validTill=$validTill")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateArn?.hashCode() ?: 0
        result = 31 * result + (certificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (certificateType?.hashCode() ?: 0)
        result = 31 * result + (customerOverride?.hashCode() ?: 0)
        result = 31 * result + (customerOverrideValidTill?.hashCode() ?: 0)
        result = 31 * result + (thumbprint?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validTill?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Certificate

        if (certificateArn != other.certificateArn) return false
        if (certificateIdentifier != other.certificateIdentifier) return false
        if (certificateType != other.certificateType) return false
        if (customerOverride != other.customerOverride) return false
        if (customerOverrideValidTill != other.customerOverrideValidTill) return false
        if (thumbprint != other.thumbprint) return false
        if (validFrom != other.validFrom) return false
        if (validTill != other.validTill) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.Certificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the certificate.
         */
        public var certificateArn: kotlin.String? = null
        /**
         * The unique key that identifies a certificate.
         */
        public var certificateIdentifier: kotlin.String? = null
        /**
         * The type of the certificate.
         */
        public var certificateType: kotlin.String? = null
        /**
         * Indicates whether there is an override for the default certificate identifier.
         */
        public var customerOverride: kotlin.Boolean? = null
        /**
         * If there is an override for the default certificate identifier, when the override expires.
         */
        public var customerOverrideValidTill: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The thumbprint of the certificate.
         */
        public var thumbprint: kotlin.String? = null
        /**
         * The starting date from which the certificate is valid.
         */
        public var validFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The final date that the certificate continues to be valid.
         */
        public var validTill: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.Certificate) : this() {
            this.certificateArn = x.certificateArn
            this.certificateIdentifier = x.certificateIdentifier
            this.certificateType = x.certificateType
            this.customerOverride = x.customerOverride
            this.customerOverrideValidTill = x.customerOverrideValidTill
            this.thumbprint = x.thumbprint
            this.validFrom = x.validFrom
            this.validTill = x.validTill
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.Certificate = Certificate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
