// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.DbInstanceAutomatedBackup
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class StopDBInstanceAutomatedBackupsReplicationOperationDeserializer: HttpDeserialize<StopDbInstanceAutomatedBackupsReplicationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StopDbInstanceAutomatedBackupsReplicationResponse {
        if (!response.status.isSuccess()) {
            throwStopDbInstanceAutomatedBackupsReplicationError(context, response)
        }
        val builder = StopDbInstanceAutomatedBackupsReplicationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStopDBInstanceAutomatedBackupsReplicationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStopDbInstanceAutomatedBackupsReplicationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStopDBInstanceAutomatedBackupsReplicationOperationBody(builder: StopDbInstanceAutomatedBackupsReplicationResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("StopDBInstanceAutomatedBackupsReplicationResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("StopDBInstanceAutomatedBackupsReplicationResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap StopDBInstanceAutomatedBackupsReplication response")
    }
    // end unwrap response wrapper

    val DBINSTANCEAUTOMATEDBACKUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBInstanceAutomatedBackup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("StopDBInstanceAutomatedBackupsReplicationResult"))
        field(DBINSTANCEAUTOMATEDBACKUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBINSTANCEAUTOMATEDBACKUP_DESCRIPTOR.index -> builder.dbInstanceAutomatedBackup = deserializeDbInstanceAutomatedBackupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
