// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RemoveTagsFromResourceResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RemoveTagsFromResourceOperationDeserializer: HttpDeserialize<RemoveTagsFromResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RemoveTagsFromResourceResponse {
        if (!response.status.isSuccess()) {
            throwRemoveTagsFromResourceError(context, response)
        }
        val builder = RemoveTagsFromResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwRemoveTagsFromResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BlueGreenDeploymentNotFoundFault" -> BlueGreenDeploymentNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyTargetGroupNotFoundFault" -> DbProxyTargetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSnapshotNotFound" -> DbSnapshotNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
