// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.RemoveRoleFromDbClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RemoveRoleFromDBClusterOperationDeserializer: HttpDeserialize<RemoveRoleFromDbClusterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RemoveRoleFromDbClusterResponse {
        if (!response.status.isSuccess()) {
            throwRemoveRoleFromDbClusterError(context, response)
        }
        val builder = RemoveRoleFromDbClusterResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwRemoveRoleFromDbClusterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterRoleNotFound" -> DbClusterRoleNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
