// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.CloudwatchLogsExportConfiguration
import aws.sdk.kotlin.services.rds.model.ModifyDbClusterRequest
import aws.sdk.kotlin.services.rds.model.ScalingConfiguration
import aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlCollectionName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ModifyDBClusterOperationSerializer: HttpSerialize<ModifyDbClusterRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ModifyDbClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeModifyDBClusterOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeModifyDBClusterOperationBody(context: ExecutionContext, input: ModifyDbClusterRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ALLOCATEDSTORAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("AllocatedStorage"))
    val ALLOWENGINEMODECHANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AllowEngineModeChange"))
    val ALLOWMAJORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AllowMajorVersionUpgrade"))
    val APPLYIMMEDIATELY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("ApplyImmediately"))
    val AUTOMINORVERSIONUPGRADE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoMinorVersionUpgrade"))
    val BACKTRACKWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, FormUrlSerialName("BacktrackWindow"))
    val BACKUPRETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("BackupRetentionPeriod"))
    val CLOUDWATCHLOGSEXPORTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("CloudwatchLogsExportConfiguration"))
    val COPYTAGSTOSNAPSHOT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("CopyTagsToSnapshot"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBClusterIdentifier"))
    val DBCLUSTERINSTANCECLASS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBClusterInstanceClass"))
    val DBCLUSTERPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBClusterParameterGroupName"))
    val DBINSTANCEPARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DBInstanceParameterGroupName"))
    val DELETIONPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DeletionProtection"))
    val DOMAIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Domain"))
    val DOMAINIAMROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DomainIAMRoleName"))
    val ENABLEGLOBALWRITEFORWARDING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableGlobalWriteForwarding"))
    val ENABLEHTTPENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableHttpEndpoint"))
    val ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnableIAMDatabaseAuthentication"))
    val ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EnablePerformanceInsights"))
    val ENGINEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineMode"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("EngineVersion"))
    val IOPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Iops"))
    val MANAGEMASTERUSERPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("ManageMasterUserPassword"))
    val MASTERUSERPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MasterUserPassword"))
    val MASTERUSERSECRETKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MasterUserSecretKmsKeyId"))
    val MONITORINGINTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MonitoringInterval"))
    val MONITORINGROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("MonitoringRoleArn"))
    val NETWORKTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NetworkType"))
    val NEWDBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NewDBClusterIdentifier"))
    val OPTIONGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("OptionGroupName"))
    val PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PerformanceInsightsKMSKeyId"))
    val PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("PerformanceInsightsRetentionPeriod"))
    val PORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Port"))
    val PREFERREDBACKUPWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredBackupWindow"))
    val PREFERREDMAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PreferredMaintenanceWindow"))
    val ROTATEMASTERUSERPASSWORD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("RotateMasterUserPassword"))
    val SCALINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ScalingConfiguration"))
    val SERVERLESSV2SCALINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ServerlessV2ScalingConfiguration"))
    val STORAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("StorageType"))
    val VPCSECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("VpcSecurityGroupIds"), FormUrlCollectionName("VpcSecurityGroupId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ModifyDBClusterMessage"))
        trait(QueryLiteral("Action", "ModifyDBCluster"))
        trait(QueryLiteral("Version", "2014-10-31"))
        field(ALLOCATEDSTORAGE_DESCRIPTOR)
        field(ALLOWENGINEMODECHANGE_DESCRIPTOR)
        field(ALLOWMAJORVERSIONUPGRADE_DESCRIPTOR)
        field(APPLYIMMEDIATELY_DESCRIPTOR)
        field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR)
        field(BACKTRACKWINDOW_DESCRIPTOR)
        field(BACKUPRETENTIONPERIOD_DESCRIPTOR)
        field(CLOUDWATCHLOGSEXPORTCONFIGURATION_DESCRIPTOR)
        field(COPYTAGSTOSNAPSHOT_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(DBCLUSTERINSTANCECLASS_DESCRIPTOR)
        field(DBCLUSTERPARAMETERGROUPNAME_DESCRIPTOR)
        field(DBINSTANCEPARAMETERGROUPNAME_DESCRIPTOR)
        field(DELETIONPROTECTION_DESCRIPTOR)
        field(DOMAIN_DESCRIPTOR)
        field(DOMAINIAMROLENAME_DESCRIPTOR)
        field(ENABLEGLOBALWRITEFORWARDING_DESCRIPTOR)
        field(ENABLEHTTPENDPOINT_DESCRIPTOR)
        field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR)
        field(ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR)
        field(ENGINEMODE_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(IOPS_DESCRIPTOR)
        field(MANAGEMASTERUSERPASSWORD_DESCRIPTOR)
        field(MASTERUSERPASSWORD_DESCRIPTOR)
        field(MASTERUSERSECRETKMSKEYID_DESCRIPTOR)
        field(MONITORINGINTERVAL_DESCRIPTOR)
        field(MONITORINGROLEARN_DESCRIPTOR)
        field(NETWORKTYPE_DESCRIPTOR)
        field(NEWDBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(OPTIONGROUPNAME_DESCRIPTOR)
        field(PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR)
        field(PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR)
        field(PORT_DESCRIPTOR)
        field(PREFERREDBACKUPWINDOW_DESCRIPTOR)
        field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR)
        field(ROTATEMASTERUSERPASSWORD_DESCRIPTOR)
        field(SCALINGCONFIGURATION_DESCRIPTOR)
        field(SERVERLESSV2SCALINGCONFIGURATION_DESCRIPTOR)
        field(STORAGETYPE_DESCRIPTOR)
        field(VPCSECURITYGROUPIDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.allocatedStorage?.let { field(ALLOCATEDSTORAGE_DESCRIPTOR, it) }
        if (input.allowEngineModeChange != false) field(ALLOWENGINEMODECHANGE_DESCRIPTOR, input.allowEngineModeChange)
        if (input.allowMajorVersionUpgrade != false) field(ALLOWMAJORVERSIONUPGRADE_DESCRIPTOR, input.allowMajorVersionUpgrade)
        if (input.applyImmediately != false) field(APPLYIMMEDIATELY_DESCRIPTOR, input.applyImmediately)
        input.autoMinorVersionUpgrade?.let { field(AUTOMINORVERSIONUPGRADE_DESCRIPTOR, it) }
        input.backtrackWindow?.let { field(BACKTRACKWINDOW_DESCRIPTOR, it) }
        input.backupRetentionPeriod?.let { field(BACKUPRETENTIONPERIOD_DESCRIPTOR, it) }
        input.cloudwatchLogsExportConfiguration?.let { field(CLOUDWATCHLOGSEXPORTCONFIGURATION_DESCRIPTOR, it, ::serializeCloudwatchLogsExportConfigurationDocument) }
        input.copyTagsToSnapshot?.let { field(COPYTAGSTOSNAPSHOT_DESCRIPTOR, it) }
        input.dbClusterIdentifier?.let { field(DBCLUSTERIDENTIFIER_DESCRIPTOR, it) }
        input.dbClusterInstanceClass?.let { field(DBCLUSTERINSTANCECLASS_DESCRIPTOR, it) }
        input.dbClusterParameterGroupName?.let { field(DBCLUSTERPARAMETERGROUPNAME_DESCRIPTOR, it) }
        input.dbInstanceParameterGroupName?.let { field(DBINSTANCEPARAMETERGROUPNAME_DESCRIPTOR, it) }
        input.deletionProtection?.let { field(DELETIONPROTECTION_DESCRIPTOR, it) }
        input.domain?.let { field(DOMAIN_DESCRIPTOR, it) }
        input.domainIamRoleName?.let { field(DOMAINIAMROLENAME_DESCRIPTOR, it) }
        input.enableGlobalWriteForwarding?.let { field(ENABLEGLOBALWRITEFORWARDING_DESCRIPTOR, it) }
        input.enableHttpEndpoint?.let { field(ENABLEHTTPENDPOINT_DESCRIPTOR, it) }
        input.enableIamDatabaseAuthentication?.let { field(ENABLEIAMDATABASEAUTHENTICATION_DESCRIPTOR, it) }
        input.enablePerformanceInsights?.let { field(ENABLEPERFORMANCEINSIGHTS_DESCRIPTOR, it) }
        input.engineMode?.let { field(ENGINEMODE_DESCRIPTOR, it) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.iops?.let { field(IOPS_DESCRIPTOR, it) }
        input.manageMasterUserPassword?.let { field(MANAGEMASTERUSERPASSWORD_DESCRIPTOR, it) }
        input.masterUserPassword?.let { field(MASTERUSERPASSWORD_DESCRIPTOR, it) }
        input.masterUserSecretKmsKeyId?.let { field(MASTERUSERSECRETKMSKEYID_DESCRIPTOR, it) }
        input.monitoringInterval?.let { field(MONITORINGINTERVAL_DESCRIPTOR, it) }
        input.monitoringRoleArn?.let { field(MONITORINGROLEARN_DESCRIPTOR, it) }
        input.networkType?.let { field(NETWORKTYPE_DESCRIPTOR, it) }
        input.newDbClusterIdentifier?.let { field(NEWDBCLUSTERIDENTIFIER_DESCRIPTOR, it) }
        input.optionGroupName?.let { field(OPTIONGROUPNAME_DESCRIPTOR, it) }
        input.performanceInsightsKmsKeyId?.let { field(PERFORMANCEINSIGHTSKMSKEYID_DESCRIPTOR, it) }
        input.performanceInsightsRetentionPeriod?.let { field(PERFORMANCEINSIGHTSRETENTIONPERIOD_DESCRIPTOR, it) }
        input.port?.let { field(PORT_DESCRIPTOR, it) }
        input.preferredBackupWindow?.let { field(PREFERREDBACKUPWINDOW_DESCRIPTOR, it) }
        input.preferredMaintenanceWindow?.let { field(PREFERREDMAINTENANCEWINDOW_DESCRIPTOR, it) }
        input.rotateMasterUserPassword?.let { field(ROTATEMASTERUSERPASSWORD_DESCRIPTOR, it) }
        input.scalingConfiguration?.let { field(SCALINGCONFIGURATION_DESCRIPTOR, it, ::serializeScalingConfigurationDocument) }
        input.serverlessV2ScalingConfiguration?.let { field(SERVERLESSV2SCALINGCONFIGURATION_DESCRIPTOR, it, ::serializeServerlessV2ScalingConfigurationDocument) }
        input.storageType?.let { field(STORAGETYPE_DESCRIPTOR, it) }
        if (input.vpcSecurityGroupIds != null) {
            listField(VPCSECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.vpcSecurityGroupIds) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
