// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.ModifyCurrentDbClusterCapacityResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyCurrentDBClusterCapacityOperationDeserializer: HttpDeserialize<ModifyCurrentDbClusterCapacityResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyCurrentDbClusterCapacityResponse {
        if (!response.status.isSuccess()) {
            throwModifyCurrentDbClusterCapacityError(context, response)
        }
        val builder = ModifyCurrentDbClusterCapacityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyCurrentDBClusterCapacityOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyCurrentDbClusterCapacityError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterCapacityFault" -> InvalidDbClusterCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyCurrentDBClusterCapacityOperationBody(builder: ModifyCurrentDbClusterCapacityResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyCurrentDBClusterCapacityResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyCurrentDBClusterCapacityResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyCurrentDBClusterCapacity response")
    }
    // end unwrap response wrapper

    val CURRENTCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("CurrentCapacity"))
    val DBCLUSTERIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DBClusterIdentifier"))
    val PENDINGCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("PendingCapacity"))
    val SECONDSBEFORETIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, XmlSerialName("SecondsBeforeTimeout"))
    val TIMEOUTACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("TimeoutAction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("ModifyCurrentDBClusterCapacityResult"))
        field(CURRENTCAPACITY_DESCRIPTOR)
        field(DBCLUSTERIDENTIFIER_DESCRIPTOR)
        field(PENDINGCAPACITY_DESCRIPTOR)
        field(SECONDSBEFORETIMEOUT_DESCRIPTOR)
        field(TIMEOUTACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CURRENTCAPACITY_DESCRIPTOR.index -> builder.currentCapacity = deserializeInt()
                DBCLUSTERIDENTIFIER_DESCRIPTOR.index -> builder.dbClusterIdentifier = deserializeString()
                PENDINGCAPACITY_DESCRIPTOR.index -> builder.pendingCapacity = deserializeInt()
                SECONDSBEFORETIMEOUT_DESCRIPTOR.index -> builder.secondsBeforeTimeout = deserializeInt()
                TIMEOUTACTION_DESCRIPTOR.index -> builder.timeoutAction = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
