// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.ActivityStreamMode
import aws.sdk.kotlin.services.rds.model.ActivityStreamPolicyStatus
import aws.sdk.kotlin.services.rds.model.ActivityStreamStatus
import aws.sdk.kotlin.services.rds.model.ModifyActivityStreamResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyActivityStreamOperationDeserializer: HttpDeserialize<ModifyActivityStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyActivityStreamResponse {
        if (!response.status.isSuccess()) {
            throwModifyActivityStreamError(context, response)
        }
        val builder = ModifyActivityStreamResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyActivityStreamOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyActivityStreamError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundFault" -> ResourceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyActivityStreamOperationBody(builder: ModifyActivityStreamResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyActivityStreamResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyActivityStreamResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyActivityStream response")
    }
    // end unwrap response wrapper

    val ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, XmlSerialName("EngineNativeAuditFieldsIncluded"))
    val KINESISSTREAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("KinesisStreamName"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("KmsKeyId"))
    val MODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Mode"))
    val POLICYSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("PolicyStatus"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("ModifyActivityStreamResult"))
        field(ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR)
        field(KINESISSTREAMNAME_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(MODE_DESCRIPTOR)
        field(POLICYSTATUS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENGINENATIVEAUDITFIELDSINCLUDED_DESCRIPTOR.index -> builder.engineNativeAuditFieldsIncluded = deserializeBoolean()
                KINESISSTREAMNAME_DESCRIPTOR.index -> builder.kinesisStreamName = deserializeString()
                KMSKEYID_DESCRIPTOR.index -> builder.kmsKeyId = deserializeString()
                MODE_DESCRIPTOR.index -> builder.mode = deserializeString().let { ActivityStreamMode.fromValue(it) }
                POLICYSTATUS_DESCRIPTOR.index -> builder.policyStatus = deserializeString().let { ActivityStreamPolicyStatus.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ActivityStreamStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
