// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.sdk.kotlin.services.rds.model.ReservedDbInstancesOffering
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeReservedDBInstancesOfferingsOperationDeserializer: HttpDeserialize<DescribeReservedDbInstancesOfferingsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeReservedDbInstancesOfferingsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeReservedDbInstancesOfferingsError(context, response)
        }
        val builder = DescribeReservedDbInstancesOfferingsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeReservedDBInstancesOfferingsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeReservedDbInstancesOfferingsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ReservedDBInstancesOfferingNotFound" -> ReservedDbInstancesOfferingNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeReservedDBInstancesOfferingsOperationBody(builder: DescribeReservedDbInstancesOfferingsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeReservedDBInstancesOfferingsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeReservedDBInstancesOfferingsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeReservedDBInstancesOfferings response")
    }
    // end unwrap response wrapper

    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val RESERVEDDBINSTANCESOFFERINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("ReservedDBInstancesOfferings"), XmlCollectionName("ReservedDBInstancesOffering"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("DescribeReservedDBInstancesOfferingsResult"))
        field(MARKER_DESCRIPTOR)
        field(RESERVEDDBINSTANCESOFFERINGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                RESERVEDDBINSTANCESOFFERINGS_DESCRIPTOR.index -> builder.reservedDbInstancesOfferings =
                    deserializer.deserializeList(RESERVEDDBINSTANCESOFFERINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ReservedDbInstancesOffering>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeReservedDbInstancesOfferingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
