// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.DbClusterBacktrack
import aws.sdk.kotlin.services.rds.model.DescribeDbClusterBacktracksResponse
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeDBClusterBacktracksOperationDeserializer: HttpDeserialize<DescribeDbClusterBacktracksResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDbClusterBacktracksResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDbClusterBacktracksError(context, response)
        }
        val builder = DescribeDbClusterBacktracksResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDBClusterBacktracksOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDbClusterBacktracksError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterBacktrackNotFoundFault" -> DbClusterBacktrackNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDBClusterBacktracksOperationBody(builder: DescribeDbClusterBacktracksResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeDBClusterBacktracksResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeDBClusterBacktracksResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeDBClusterBacktracks response")
    }
    // end unwrap response wrapper

    val DBCLUSTERBACKTRACKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("DBClusterBacktracks"), XmlCollectionName("DBClusterBacktrack"))
    val MARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Marker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("DescribeDBClusterBacktracksResult"))
        field(DBCLUSTERBACKTRACKS_DESCRIPTOR)
        field(MARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBCLUSTERBACKTRACKS_DESCRIPTOR.index -> builder.dbClusterBacktracks =
                    deserializer.deserializeList(DBCLUSTERBACKTRACKS_DESCRIPTOR) {
                        val col0 = mutableListOf<DbClusterBacktrack>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDbClusterBacktrackDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MARKER_DESCRIPTOR.index -> builder.marker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
