// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointResponse
import aws.sdk.kotlin.services.rds.model.DbProxyEndpoint
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateDBProxyEndpointOperationDeserializer: HttpDeserialize<CreateDbProxyEndpointResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDbProxyEndpointResponse {
        if (!response.status.isSuccess()) {
            throwCreateDbProxyEndpointError(context, response)
        }
        val builder = CreateDbProxyEndpointResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBProxyEndpointOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateDbProxyEndpointError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBProxyEndpointAlreadyExistsFault" -> DbProxyEndpointAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyEndpointQuotaExceededFault" -> DbProxyEndpointQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "DBProxyNotFoundFault" -> DbProxyNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBProxyStateFault" -> InvalidDbProxyStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBProxyEndpointOperationBody(builder: CreateDbProxyEndpointResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateDBProxyEndpointResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateDBProxyEndpointResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateDBProxyEndpoint response")
    }
    // end unwrap response wrapper

    val DBPROXYENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBProxyEndpoint"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("CreateDBProxyEndpointResult"))
        field(DBPROXYENDPOINT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBPROXYENDPOINT_DESCRIPTOR.index -> builder.dbProxyEndpoint = deserializeDbProxyEndpointDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
