// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.transform

import aws.sdk.kotlin.services.rds.model.CreateDbInstanceReadReplicaResponse
import aws.sdk.kotlin.services.rds.model.DbInstance
import aws.sdk.kotlin.services.rds.model.RdsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateDBInstanceReadReplicaOperationDeserializer: HttpDeserialize<CreateDbInstanceReadReplicaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateDbInstanceReadReplicaResponse {
        if (!response.status.isSuccess()) {
            throwCreateDbInstanceReadReplicaError(context, response)
        }
        val builder = CreateDbInstanceReadReplicaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDBInstanceReadReplicaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateDbInstanceReadReplicaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw RdsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DBClusterNotFoundFault" -> DbClusterNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceAlreadyExists" -> DbInstanceAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "DBInstanceNotFound" -> DbInstanceNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBParameterGroupNotFound" -> DbParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSecurityGroupNotFound" -> DbSecurityGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSubnetGroupDoesNotCoverEnoughAZs" -> DbSubnetGroupDoesNotCoverEnoughAZsDeserializer().deserialize(context, wrappedResponse)
        "DBSubnetGroupNotAllowedFault" -> DbSubnetGroupNotAllowedFaultDeserializer().deserialize(context, wrappedResponse)
        "DBSubnetGroupNotFoundFault" -> DbSubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "DomainNotFoundFault" -> DomainNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "InstanceQuotaExceeded" -> InstanceQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "InsufficientDBInstanceCapacity" -> InsufficientDbInstanceCapacityFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBClusterStateFault" -> InvalidDbClusterStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBInstanceState" -> InvalidDbInstanceStateFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidDBSubnetGroupFault" -> InvalidDbSubnetGroupFaultDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetDeserializer().deserialize(context, wrappedResponse)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedResponse)
        "KMSKeyNotAccessibleFault" -> KmsKeyNotAccessibleFaultDeserializer().deserialize(context, wrappedResponse)
        "NetworkTypeNotSupported" -> NetworkTypeNotSupportedDeserializer().deserialize(context, wrappedResponse)
        "OptionGroupNotFoundFault" -> OptionGroupNotFoundFaultDeserializer().deserialize(context, wrappedResponse)
        "ProvisionedIopsNotAvailableInAZFault" -> ProvisionedIopsNotAvailableInAzFaultDeserializer().deserialize(context, wrappedResponse)
        "StorageQuotaExceeded" -> StorageQuotaExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "StorageTypeNotSupported" -> StorageTypeNotSupportedFaultDeserializer().deserialize(context, wrappedResponse)
        else -> RdsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDBInstanceReadReplicaOperationBody(builder: CreateDbInstanceReadReplicaResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateDBInstanceReadReplicaResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateDBInstanceReadReplicaResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateDBInstanceReadReplica response")
    }
    // end unwrap response wrapper

    val DBINSTANCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DBInstance"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://rds.amazonaws.com/doc/2014-10-31/"))
        trait(XmlSerialName("CreateDBInstanceReadReplicaResult"))
        field(DBINSTANCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DBINSTANCE_DESCRIPTOR.index -> builder.dbInstance = deserializeDbInstanceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
