// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Shows the scaling configuration for an Aurora Serverless v2 DB cluster.
 *
 * For more information, see [Using Amazon Aurora Serverless v2](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html) in the *Amazon Aurora User Guide*.
 */
public class ServerlessV2ScalingConfigurationInfo private constructor(builder: Builder) {
    /**
     * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
     */
    public val maxCapacity: kotlin.Double? = builder.maxCapacity
    /**
     * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.
     */
    public val minCapacity: kotlin.Double? = builder.minCapacity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerlessV2ScalingConfigurationInfo(")
        append("maxCapacity=$maxCapacity,")
        append("minCapacity=$minCapacity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxCapacity?.hashCode() ?: 0
        result = 31 * result + (minCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerlessV2ScalingConfigurationInfo

        if (maxCapacity != other.maxCapacity) return false
        if (minCapacity != other.minCapacity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 40, 40.5, 41, and so on. The largest value that you can use is 128.
         */
        public var maxCapacity: kotlin.Double? = null
        /**
         * The minimum number of Aurora capacity units (ACUs) for a DB instance in an Aurora Serverless v2 cluster. You can specify ACU values in half-step increments, such as 8, 8.5, 9, and so on. The smallest value that you can use is 0.5.
         */
        public var minCapacity: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo) : this() {
            this.maxCapacity = x.maxCapacity
            this.minCapacity = x.minCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfigurationInfo = ServerlessV2ScalingConfigurationInfo(this)
    }
}
