// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains a list of available options for a DB instance.
 *
 * This data type is used as a response element in the `DescribeOrderableDBInstanceOptions` action.
 */
public class OrderableDbInstanceOption private constructor(builder: Builder) {
    /**
     * The Availability Zone group for a DB instance.
     */
    public val availabilityZoneGroup: kotlin.String? = builder.availabilityZoneGroup
    /**
     * A list of Availability Zones for a DB instance.
     */
    public val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * A list of the available processor features for the DB instance class of a DB instance.
     */
    public val availableProcessorFeatures: List<AvailableProcessorFeature>? = builder.availableProcessorFeatures
    /**
     * The DB instance class for a DB instance.
     */
    public val dbInstanceClass: kotlin.String? = builder.dbInstanceClass
    /**
     * The engine type of a DB instance.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The engine version of a DB instance.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The license model for a DB instance.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Maximum total provisioned IOPS for a DB instance.
     */
    public val maxIopsPerDbInstance: kotlin.Int? = builder.maxIopsPerDbInstance
    /**
     * Maximum provisioned IOPS per GiB for a DB instance.
     */
    public val maxIopsPerGib: kotlin.Double? = builder.maxIopsPerGib
    /**
     * Maximum storage size for a DB instance.
     */
    public val maxStorageSize: kotlin.Int? = builder.maxStorageSize
    /**
     * Maximum storage throughput for a DB instance.
     */
    public val maxStorageThroughputPerDbInstance: kotlin.Int? = builder.maxStorageThroughputPerDbInstance
    /**
     * Maximum storage throughput to provisioned IOPS ratio for a DB instance.
     */
    public val maxStorageThroughputPerIops: kotlin.Double? = builder.maxStorageThroughputPerIops
    /**
     * Minimum total provisioned IOPS for a DB instance.
     */
    public val minIopsPerDbInstance: kotlin.Int? = builder.minIopsPerDbInstance
    /**
     * Minimum provisioned IOPS per GiB for a DB instance.
     */
    public val minIopsPerGib: kotlin.Double? = builder.minIopsPerGib
    /**
     * Minimum storage size for a DB instance.
     */
    public val minStorageSize: kotlin.Int? = builder.minStorageSize
    /**
     * Minimum storage throughput for a DB instance.
     */
    public val minStorageThroughputPerDbInstance: kotlin.Int? = builder.minStorageThroughputPerDbInstance
    /**
     * Minimum storage throughput to provisioned IOPS ratio for a DB instance.
     */
    public val minStorageThroughputPerIops: kotlin.Double? = builder.minStorageThroughputPerIops
    /**
     * Indicates whether a DB instance is Multi-AZ capable.
     */
    public val multiAzCapable: kotlin.Boolean = builder.multiAzCapable
    /**
     * Whether a DB instance supports RDS on Outposts.
     *
     * For more information about RDS on Outposts, see [Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide.*
     */
    public val outpostCapable: kotlin.Boolean = builder.outpostCapable
    /**
     * Indicates whether a DB instance can have a read replica.
     */
    public val readReplicaCapable: kotlin.Boolean = builder.readReplicaCapable
    /**
     * Indicates the storage type for a DB instance.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value `[sync, async]`. Aurora MySQL and RDS for Oracle return `[async]` only. If Database Activity Streams isn't supported, the return value is an empty list.
     */
    public val supportedActivityStreamModes: List<String>? = builder.supportedActivityStreamModes
    /**
     * A list of the supported DB engine modes.
     */
    public val supportedEngineModes: List<String>? = builder.supportedEngineModes
    /**
     * The network types supported by the DB instance (`IPV4` or `DUAL`).
     *
     * A DB instance can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
     *
     * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
     */
    public val supportedNetworkTypes: List<String>? = builder.supportedNetworkTypes
    /**
     * Whether DB instances can be configured as a Multi-AZ DB cluster.
     *
     * For more information on Multi-AZ DB clusters, see [ Multi-AZ deployments with two readable standby DB instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
     */
    public val supportsClusters: kotlin.Boolean = builder.supportsClusters
    /**
     * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    public val supportsEnhancedMonitoring: kotlin.Boolean = builder.supportsEnhancedMonitoring
    /**
     * A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.
     */
    public val supportsGlobalDatabases: kotlin.Boolean = builder.supportsGlobalDatabases
    /**
     * Indicates whether a DB instance supports IAM database authentication.
     */
    public val supportsIamDatabaseAuthentication: kotlin.Boolean = builder.supportsIamDatabaseAuthentication
    /**
     * Indicates whether a DB instance supports provisioned IOPS.
     */
    public val supportsIops: kotlin.Boolean = builder.supportsIops
    /**
     * Whether a DB instance supports Kerberos Authentication.
     */
    public val supportsKerberosAuthentication: kotlin.Boolean? = builder.supportsKerberosAuthentication
    /**
     * True if a DB instance supports Performance Insights, otherwise false.
     */
    public val supportsPerformanceInsights: kotlin.Boolean = builder.supportsPerformanceInsights
    /**
     * Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     */
    public val supportsStorageAutoscaling: kotlin.Boolean? = builder.supportsStorageAutoscaling
    /**
     * Indicates whether a DB instance supports encrypted storage.
     */
    public val supportsStorageEncryption: kotlin.Boolean = builder.supportsStorageEncryption
    /**
     * Indicates whether a DB instance supports storage throughput.
     */
    public val supportsStorageThroughput: kotlin.Boolean = builder.supportsStorageThroughput
    /**
     * Indicates whether a DB instance is in a VPC.
     */
    public val vpc: kotlin.Boolean = builder.vpc

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrderableDbInstanceOption(")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("availabilityZones=$availabilityZones,")
        append("availableProcessorFeatures=$availableProcessorFeatures,")
        append("dbInstanceClass=$dbInstanceClass,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("licenseModel=$licenseModel,")
        append("maxIopsPerDbInstance=$maxIopsPerDbInstance,")
        append("maxIopsPerGib=$maxIopsPerGib,")
        append("maxStorageSize=$maxStorageSize,")
        append("maxStorageThroughputPerDbInstance=$maxStorageThroughputPerDbInstance,")
        append("maxStorageThroughputPerIops=$maxStorageThroughputPerIops,")
        append("minIopsPerDbInstance=$minIopsPerDbInstance,")
        append("minIopsPerGib=$minIopsPerGib,")
        append("minStorageSize=$minStorageSize,")
        append("minStorageThroughputPerDbInstance=$minStorageThroughputPerDbInstance,")
        append("minStorageThroughputPerIops=$minStorageThroughputPerIops,")
        append("multiAzCapable=$multiAzCapable,")
        append("outpostCapable=$outpostCapable,")
        append("readReplicaCapable=$readReplicaCapable,")
        append("storageType=$storageType,")
        append("supportedActivityStreamModes=$supportedActivityStreamModes,")
        append("supportedEngineModes=$supportedEngineModes,")
        append("supportedNetworkTypes=$supportedNetworkTypes,")
        append("supportsClusters=$supportsClusters,")
        append("supportsEnhancedMonitoring=$supportsEnhancedMonitoring,")
        append("supportsGlobalDatabases=$supportsGlobalDatabases,")
        append("supportsIamDatabaseAuthentication=$supportsIamDatabaseAuthentication,")
        append("supportsIops=$supportsIops,")
        append("supportsKerberosAuthentication=$supportsKerberosAuthentication,")
        append("supportsPerformanceInsights=$supportsPerformanceInsights,")
        append("supportsStorageAutoscaling=$supportsStorageAutoscaling,")
        append("supportsStorageEncryption=$supportsStorageEncryption,")
        append("supportsStorageThroughput=$supportsStorageThroughput,")
        append("vpc=$vpc")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneGroup?.hashCode() ?: 0
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (availableProcessorFeatures?.hashCode() ?: 0)
        result = 31 * result + (dbInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (maxIopsPerDbInstance ?: 0)
        result = 31 * result + (maxIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (maxStorageSize ?: 0)
        result = 31 * result + (maxStorageThroughputPerDbInstance ?: 0)
        result = 31 * result + (maxStorageThroughputPerIops?.hashCode() ?: 0)
        result = 31 * result + (minIopsPerDbInstance ?: 0)
        result = 31 * result + (minIopsPerGib?.hashCode() ?: 0)
        result = 31 * result + (minStorageSize ?: 0)
        result = 31 * result + (minStorageThroughputPerDbInstance ?: 0)
        result = 31 * result + (minStorageThroughputPerIops?.hashCode() ?: 0)
        result = 31 * result + (multiAzCapable.hashCode())
        result = 31 * result + (outpostCapable.hashCode())
        result = 31 * result + (readReplicaCapable.hashCode())
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (supportedActivityStreamModes?.hashCode() ?: 0)
        result = 31 * result + (supportedEngineModes?.hashCode() ?: 0)
        result = 31 * result + (supportedNetworkTypes?.hashCode() ?: 0)
        result = 31 * result + (supportsClusters.hashCode())
        result = 31 * result + (supportsEnhancedMonitoring.hashCode())
        result = 31 * result + (supportsGlobalDatabases.hashCode())
        result = 31 * result + (supportsIamDatabaseAuthentication.hashCode())
        result = 31 * result + (supportsIops.hashCode())
        result = 31 * result + (supportsKerberosAuthentication?.hashCode() ?: 0)
        result = 31 * result + (supportsPerformanceInsights.hashCode())
        result = 31 * result + (supportsStorageAutoscaling?.hashCode() ?: 0)
        result = 31 * result + (supportsStorageEncryption.hashCode())
        result = 31 * result + (supportsStorageThroughput.hashCode())
        result = 31 * result + (vpc.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrderableDbInstanceOption

        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (availabilityZones != other.availabilityZones) return false
        if (availableProcessorFeatures != other.availableProcessorFeatures) return false
        if (dbInstanceClass != other.dbInstanceClass) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (licenseModel != other.licenseModel) return false
        if (maxIopsPerDbInstance != other.maxIopsPerDbInstance) return false
        if (maxIopsPerGib != other.maxIopsPerGib) return false
        if (maxStorageSize != other.maxStorageSize) return false
        if (maxStorageThroughputPerDbInstance != other.maxStorageThroughputPerDbInstance) return false
        if (maxStorageThroughputPerIops != other.maxStorageThroughputPerIops) return false
        if (minIopsPerDbInstance != other.minIopsPerDbInstance) return false
        if (minIopsPerGib != other.minIopsPerGib) return false
        if (minStorageSize != other.minStorageSize) return false
        if (minStorageThroughputPerDbInstance != other.minStorageThroughputPerDbInstance) return false
        if (minStorageThroughputPerIops != other.minStorageThroughputPerIops) return false
        if (multiAzCapable != other.multiAzCapable) return false
        if (outpostCapable != other.outpostCapable) return false
        if (readReplicaCapable != other.readReplicaCapable) return false
        if (storageType != other.storageType) return false
        if (supportedActivityStreamModes != other.supportedActivityStreamModes) return false
        if (supportedEngineModes != other.supportedEngineModes) return false
        if (supportedNetworkTypes != other.supportedNetworkTypes) return false
        if (supportsClusters != other.supportsClusters) return false
        if (supportsEnhancedMonitoring != other.supportsEnhancedMonitoring) return false
        if (supportsGlobalDatabases != other.supportsGlobalDatabases) return false
        if (supportsIamDatabaseAuthentication != other.supportsIamDatabaseAuthentication) return false
        if (supportsIops != other.supportsIops) return false
        if (supportsKerberosAuthentication != other.supportsKerberosAuthentication) return false
        if (supportsPerformanceInsights != other.supportsPerformanceInsights) return false
        if (supportsStorageAutoscaling != other.supportsStorageAutoscaling) return false
        if (supportsStorageEncryption != other.supportsStorageEncryption) return false
        if (supportsStorageThroughput != other.supportsStorageThroughput) return false
        if (vpc != other.vpc) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Availability Zone group for a DB instance.
         */
        public var availabilityZoneGroup: kotlin.String? = null
        /**
         * A list of Availability Zones for a DB instance.
         */
        public var availabilityZones: List<AvailabilityZone>? = null
        /**
         * A list of the available processor features for the DB instance class of a DB instance.
         */
        public var availableProcessorFeatures: List<AvailableProcessorFeature>? = null
        /**
         * The DB instance class for a DB instance.
         */
        public var dbInstanceClass: kotlin.String? = null
        /**
         * The engine type of a DB instance.
         */
        public var engine: kotlin.String? = null
        /**
         * The engine version of a DB instance.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The license model for a DB instance.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Maximum total provisioned IOPS for a DB instance.
         */
        public var maxIopsPerDbInstance: kotlin.Int? = null
        /**
         * Maximum provisioned IOPS per GiB for a DB instance.
         */
        public var maxIopsPerGib: kotlin.Double? = null
        /**
         * Maximum storage size for a DB instance.
         */
        public var maxStorageSize: kotlin.Int? = null
        /**
         * Maximum storage throughput for a DB instance.
         */
        public var maxStorageThroughputPerDbInstance: kotlin.Int? = null
        /**
         * Maximum storage throughput to provisioned IOPS ratio for a DB instance.
         */
        public var maxStorageThroughputPerIops: kotlin.Double? = null
        /**
         * Minimum total provisioned IOPS for a DB instance.
         */
        public var minIopsPerDbInstance: kotlin.Int? = null
        /**
         * Minimum provisioned IOPS per GiB for a DB instance.
         */
        public var minIopsPerGib: kotlin.Double? = null
        /**
         * Minimum storage size for a DB instance.
         */
        public var minStorageSize: kotlin.Int? = null
        /**
         * Minimum storage throughput for a DB instance.
         */
        public var minStorageThroughputPerDbInstance: kotlin.Int? = null
        /**
         * Minimum storage throughput to provisioned IOPS ratio for a DB instance.
         */
        public var minStorageThroughputPerIops: kotlin.Double? = null
        /**
         * Indicates whether a DB instance is Multi-AZ capable.
         */
        public var multiAzCapable: kotlin.Boolean = false
        /**
         * Whether a DB instance supports RDS on Outposts.
         *
         * For more information about RDS on Outposts, see [Amazon RDS on Amazon Web Services Outposts](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html) in the *Amazon RDS User Guide.*
         */
        public var outpostCapable: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance can have a read replica.
         */
        public var readReplicaCapable: kotlin.Boolean = false
        /**
         * Indicates the storage type for a DB instance.
         */
        public var storageType: kotlin.String? = null
        /**
         * The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value `[sync, async]`. Aurora MySQL and RDS for Oracle return `[async]` only. If Database Activity Streams isn't supported, the return value is an empty list.
         */
        public var supportedActivityStreamModes: List<String>? = null
        /**
         * A list of the supported DB engine modes.
         */
        public var supportedEngineModes: List<String>? = null
        /**
         * The network types supported by the DB instance (`IPV4` or `DUAL`).
         *
         * A DB instance can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (`DUAL`).
         *
         * For more information, see [ Working with a DB instance in a VPC](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html) in the *Amazon RDS User Guide.*
         */
        public var supportedNetworkTypes: List<String>? = null
        /**
         * Whether DB instances can be configured as a Multi-AZ DB cluster.
         *
         * For more information on Multi-AZ DB clusters, see [ Multi-AZ deployments with two readable standby DB instances](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html) in the *Amazon RDS User Guide.*
         */
        public var supportsClusters: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
         */
        public var supportsEnhancedMonitoring: kotlin.Boolean = false
        /**
         * A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.
         */
        public var supportsGlobalDatabases: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports IAM database authentication.
         */
        public var supportsIamDatabaseAuthentication: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports provisioned IOPS.
         */
        public var supportsIops: kotlin.Boolean = false
        /**
         * Whether a DB instance supports Kerberos Authentication.
         */
        public var supportsKerberosAuthentication: kotlin.Boolean? = null
        /**
         * True if a DB instance supports Performance Insights, otherwise false.
         */
        public var supportsPerformanceInsights: kotlin.Boolean = false
        /**
         * Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
         */
        public var supportsStorageAutoscaling: kotlin.Boolean? = null
        /**
         * Indicates whether a DB instance supports encrypted storage.
         */
        public var supportsStorageEncryption: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance supports storage throughput.
         */
        public var supportsStorageThroughput: kotlin.Boolean = false
        /**
         * Indicates whether a DB instance is in a VPC.
         */
        public var vpc: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption) : this() {
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.availabilityZones = x.availabilityZones
            this.availableProcessorFeatures = x.availableProcessorFeatures
            this.dbInstanceClass = x.dbInstanceClass
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.licenseModel = x.licenseModel
            this.maxIopsPerDbInstance = x.maxIopsPerDbInstance
            this.maxIopsPerGib = x.maxIopsPerGib
            this.maxStorageSize = x.maxStorageSize
            this.maxStorageThroughputPerDbInstance = x.maxStorageThroughputPerDbInstance
            this.maxStorageThroughputPerIops = x.maxStorageThroughputPerIops
            this.minIopsPerDbInstance = x.minIopsPerDbInstance
            this.minIopsPerGib = x.minIopsPerGib
            this.minStorageSize = x.minStorageSize
            this.minStorageThroughputPerDbInstance = x.minStorageThroughputPerDbInstance
            this.minStorageThroughputPerIops = x.minStorageThroughputPerIops
            this.multiAzCapable = x.multiAzCapable
            this.outpostCapable = x.outpostCapable
            this.readReplicaCapable = x.readReplicaCapable
            this.storageType = x.storageType
            this.supportedActivityStreamModes = x.supportedActivityStreamModes
            this.supportedEngineModes = x.supportedEngineModes
            this.supportedNetworkTypes = x.supportedNetworkTypes
            this.supportsClusters = x.supportsClusters
            this.supportsEnhancedMonitoring = x.supportsEnhancedMonitoring
            this.supportsGlobalDatabases = x.supportsGlobalDatabases
            this.supportsIamDatabaseAuthentication = x.supportsIamDatabaseAuthentication
            this.supportsIops = x.supportsIops
            this.supportsKerberosAuthentication = x.supportsKerberosAuthentication
            this.supportsPerformanceInsights = x.supportsPerformanceInsights
            this.supportsStorageAutoscaling = x.supportsStorageAutoscaling
            this.supportsStorageEncryption = x.supportsStorageEncryption
            this.supportsStorageThroughput = x.supportsStorageThroughput
            this.vpc = x.vpc
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.OrderableDbInstanceOption = OrderableDbInstanceOption(this)
    }
}
