// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class ModifyGlobalClusterRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether major version upgrades are allowed.
     *
     * Constraints: You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
     *
     * If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.
     */
    public val allowMajorVersionUpgrade: kotlin.Boolean? = builder.allowMajorVersionUpgrade
    /**
     * Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
     *
     * To list all of the available engine versions for `aurora-mysql` (for MySQL-based Aurora global databases), use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'`
     *
     * To list all of the available engine versions for `aurora-postgresql` (for PostgreSQL-based Aurora global databases), use the following command:
     *
     * `aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'`
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match the identifier of an existing global database cluster.
     */
    public val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 letters, numbers, or hyphens
     * + The first character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-cluster2`
     */
    public val newGlobalClusterIdentifier: kotlin.String? = builder.newGlobalClusterIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyGlobalClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyGlobalClusterRequest(")
        append("allowMajorVersionUpgrade=$allowMajorVersionUpgrade,")
        append("deletionProtection=$deletionProtection,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("newGlobalClusterIdentifier=$newGlobalClusterIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowMajorVersionUpgrade?.hashCode() ?: 0
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (newGlobalClusterIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyGlobalClusterRequest

        if (allowMajorVersionUpgrade != other.allowMajorVersionUpgrade) return false
        if (deletionProtection != other.deletionProtection) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (newGlobalClusterIdentifier != other.newGlobalClusterIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyGlobalClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates whether major version upgrades are allowed.
         *
         * Constraints: You must allow major version upgrades when specifying a value for the `EngineVersion` parameter that is a different major version than the DB cluster's current version.
         *
         * If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.
         */
        public var allowMajorVersionUpgrade: kotlin.Boolean? = null
        /**
         * Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless `ApplyImmediately` is enabled.
         *
         * To list all of the available engine versions for `aurora-mysql` (for MySQL-based Aurora global databases), use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'`
         *
         * To list all of the available engine versions for `aurora-postgresql` (for PostgreSQL-based Aurora global databases), use the following command:
         *
         * `aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'`
         */
        public var engineVersion: kotlin.String? = null
        /**
         * The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match the identifier of an existing global database cluster.
         */
        public var globalClusterIdentifier: kotlin.String? = null
        /**
         * The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 letters, numbers, or hyphens
         * + The first character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-cluster2`
         */
        public var newGlobalClusterIdentifier: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyGlobalClusterRequest) : this() {
            this.allowMajorVersionUpgrade = x.allowMajorVersionUpgrade
            this.deletionProtection = x.deletionProtection
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.newGlobalClusterIdentifier = x.newGlobalClusterIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyGlobalClusterRequest = ModifyGlobalClusterRequest(this)
    }
}
