// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class ModifyDbSnapshotAttributeRequest private constructor(builder: Builder) {
    /**
     * The name of the DB snapshot attribute to modify.
     *
     * To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this value to `restore`.
     *
     * To view the list of attributes available to modify, use the DescribeDBSnapshotAttributes API operation.
     */
    public val attributeName: kotlin.String? = builder.attributeName
    /**
     * The identifier for the DB snapshot to modify the attributes for.
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * A list of DB snapshot attributes to add to the attribute specified by `AttributeName`.
     *
     * To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account IDs, or `all` to make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the `all` value for any manual DB snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
     */
    public val valuesToAdd: List<String>? = builder.valuesToAdd
    /**
     * A list of DB snapshot attributes to remove from the attribute specified by `AttributeName`.
     *
     * To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account identifiers, or `all` to remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify `all`, an Amazon Web Services account whose account ID is explicitly added to the `restore` attribute can still copy or restore the manual DB snapshot.
     */
    public val valuesToRemove: List<String>? = builder.valuesToRemove

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotAttributeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDbSnapshotAttributeRequest(")
        append("attributeName=$attributeName,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("valuesToAdd=$valuesToAdd,")
        append("valuesToRemove=$valuesToRemove")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (valuesToAdd?.hashCode() ?: 0)
        result = 31 * result + (valuesToRemove?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDbSnapshotAttributeRequest

        if (attributeName != other.attributeName) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (valuesToAdd != other.valuesToAdd) return false
        if (valuesToRemove != other.valuesToRemove) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotAttributeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the DB snapshot attribute to modify.
         *
         * To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this value to `restore`.
         *
         * To view the list of attributes available to modify, use the DescribeDBSnapshotAttributes API operation.
         */
        public var attributeName: kotlin.String? = null
        /**
         * The identifier for the DB snapshot to modify the attributes for.
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * A list of DB snapshot attributes to add to the attribute specified by `AttributeName`.
         *
         * To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account IDs, or `all` to make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the `all` value for any manual DB snapshots that contain private information that you don't want available to all Amazon Web Services accounts.
         */
        public var valuesToAdd: List<String>? = null
        /**
         * A list of DB snapshot attributes to remove from the attribute specified by `AttributeName`.
         *
         * To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account identifiers, or `all` to remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify `all`, an Amazon Web Services account whose account ID is explicitly added to the `restore` attribute can still copy or restore the manual DB snapshot.
         */
        public var valuesToRemove: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotAttributeRequest) : this() {
            this.attributeName = x.attributeName
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.valuesToAdd = x.valuesToAdd
            this.valuesToRemove = x.valuesToRemove
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.ModifyDbSnapshotAttributeRequest = ModifyDbSnapshotAttributeRequest(this)
    }
}
