// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:
 * + `CreateDBInstance`
 * + `DescribeDBInstances`
 * + `DeleteDBInstance`
 *
 * For the data structure that represents Amazon Aurora DB cluster endpoints, see `DBClusterEndpoint`.
 */
public class Endpoint private constructor(builder: Builder) {
    /**
     * Specifies the DNS address of the DB instance.
     */
    public val address: kotlin.String? = builder.address
    /**
     * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
     */
    public val hostedZoneId: kotlin.String? = builder.hostedZoneId
    /**
     * Specifies the port that the database engine is listening on.
     */
    public val port: kotlin.Int = builder.port

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.Endpoint = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Endpoint(")
        append("address=$address,")
        append("hostedZoneId=$hostedZoneId,")
        append("port=$port")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = address?.hashCode() ?: 0
        result = 31 * result + (hostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (port)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Endpoint

        if (address != other.address) return false
        if (hostedZoneId != other.hostedZoneId) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.Endpoint = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the DNS address of the DB instance.
         */
        public var address: kotlin.String? = null
        /**
         * Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
         */
        public var hostedZoneId: kotlin.String? = null
        /**
         * Specifies the port that the database engine is listening on.
         */
        public var port: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.Endpoint) : this() {
            this.address = x.address
            this.hostedZoneId = x.hostedZoneId
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.Endpoint = Endpoint(this)
    }
}
