// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class DescribeDbLogFilesRequest private constructor(builder: Builder) {
    /**
     * The customer-assigned name of the DB instance that contains the log files you want to list.
     *
     * Constraints:
     * + Must match the identifier of an existing DBInstance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.
     */
    public val fileLastWritten: kotlin.Long = builder.fileLastWritten
    /**
     * Filters the available log files for files larger than the specified size.
     */
    public val fileSize: kotlin.Long = builder.fileSize
    /**
     * Filters the available log files for log file names that contain the specified string.
     */
    public val filenameContains: kotlin.String? = builder.filenameContains
    /**
     * This parameter isn't currently supported.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbLogFilesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbLogFilesRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("fileLastWritten=$fileLastWritten,")
        append("fileSize=$fileSize,")
        append("filenameContains=$filenameContains,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (fileLastWritten.hashCode())
        result = 31 * result + (fileSize.hashCode())
        result = 31 * result + (filenameContains?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbLogFilesRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (fileLastWritten != other.fileLastWritten) return false
        if (fileSize != other.fileSize) return false
        if (filenameContains != other.filenameContains) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbLogFilesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The customer-assigned name of the DB instance that contains the log files you want to list.
         *
         * Constraints:
         * + Must match the identifier of an existing DBInstance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.
         */
        public var fileLastWritten: kotlin.Long = 0L
        /**
         * Filters the available log files for files larger than the specified size.
         */
        public var fileSize: kotlin.Long = 0L
        /**
         * Filters the available log files for log file names that contain the specified string.
         */
        public var filenameContains: kotlin.String? = null
        /**
         * This parameter isn't currently supported.
         */
        public var filters: List<Filter>? = null
        /**
         * The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbLogFilesRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.fileLastWritten = x.fileLastWritten
            this.fileSize = x.fileSize
            this.filenameContains = x.filenameContains
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbLogFilesRequest = DescribeDbLogFilesRequest(this)
    }
}
