// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class DescribeBlueGreenDeploymentsRequest private constructor(builder: Builder) {
    /**
     * The blue/green deployment identifier. If this parameter is specified, information from only the specific blue/green deployment is returned. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + If supplied, must match an existing blue/green deployment identifier.
     */
    public val blueGreenDeploymentIdentifier: kotlin.String? = builder.blueGreenDeploymentIdentifier
    /**
     * A filter that specifies one or more blue/green deployments to describe.
     *
     * Supported filters:
     * + `blue-green-deployment-identifier` - Accepts system-generated identifiers for blue/green deployments. The results list only includes information about the blue/green deployments with the specified identifiers.
     * + `blue-green-deployment-name` - Accepts user-supplied names for blue/green deployments. The results list only includes information about the blue/green deployments with the specified names.
     * + `source` - Accepts source databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified source databases.
     * + `target` - Accepts target databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified target databases.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous `DescribeBlueGreenDeployments` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
     *
     * Default: 100
     *
     * Constraints: Minimum 20, maximum 100.
     */
    public val maxRecords: kotlin.Int? = builder.maxRecords

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeBlueGreenDeploymentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeBlueGreenDeploymentsRequest(")
        append("blueGreenDeploymentIdentifier=$blueGreenDeploymentIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blueGreenDeploymentIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeBlueGreenDeploymentsRequest

        if (blueGreenDeploymentIdentifier != other.blueGreenDeploymentIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeBlueGreenDeploymentsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The blue/green deployment identifier. If this parameter is specified, information from only the specific blue/green deployment is returned. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + If supplied, must match an existing blue/green deployment identifier.
         */
        public var blueGreenDeploymentIdentifier: kotlin.String? = null
        /**
         * A filter that specifies one or more blue/green deployments to describe.
         *
         * Supported filters:
         * + `blue-green-deployment-identifier` - Accepts system-generated identifiers for blue/green deployments. The results list only includes information about the blue/green deployments with the specified identifiers.
         * + `blue-green-deployment-name` - Accepts user-supplied names for blue/green deployments. The results list only includes information about the blue/green deployments with the specified names.
         * + `source` - Accepts source databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified source databases.
         * + `target` - Accepts target databases for a blue/green deployment. The results list only includes information about the blue/green deployments with the specified target databases.
         */
        public var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous `DescribeBlueGreenDeployments` request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by `MaxRecords`.
         */
        public var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified `MaxRecords` value, a pagination token called a marker is included in the response so you can retrieve the remaining results.
         *
         * Default: 100
         *
         * Constraints: Minimum 20, maximum 100.
         */
        public var maxRecords: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeBlueGreenDeploymentsRequest) : this() {
            this.blueGreenDeploymentIdentifier = x.blueGreenDeploymentIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeBlueGreenDeploymentsRequest = DescribeBlueGreenDeploymentsRequest(this)
    }
}
