// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class DeleteDbClusterRequest private constructor(builder: Builder) {
    /**
     * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
     *
     * Constraints:
     * + Must match an existing DBClusterIdentifier.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is disabled.
     *
     * Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the `SkipFinalShapshot` parameter results in an error.
     *
     * Constraints:
     * + Must be 1 to 255 letters, numbers, or hyphens.
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     */
    public val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.
     *
     * You must specify a `FinalDBSnapshotIdentifier` parameter if `SkipFinalSnapshot` is disabled.
     */
    public val skipFinalSnapshot: kotlin.Boolean = builder.skipFinalSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbClusterRequest(")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterIdentifier?.hashCode() ?: 0
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDbClusterRequest

        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.
         *
         * Constraints:
         * + Must match an existing DBClusterIdentifier.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The DB cluster snapshot identifier of the new DB cluster snapshot created when `SkipFinalSnapshot` is disabled.
         *
         * Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the `SkipFinalShapshot` parameter results in an error.
         *
         * Constraints:
         * + Must be 1 to 255 letters, numbers, or hyphens.
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         */
        public var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.
         *
         * You must specify a `FinalDBSnapshotIdentifier` parameter if `SkipFinalSnapshot` is disabled.
         */
        public var skipFinalSnapshot: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest) : this() {
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DeleteDbClusterRequest = DeleteDbClusterRequest(this)
    }
}
