// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 *
 * This data type is used as a response element in the `DescribeDBProxyTargetGroups` action.
 */
public class DbProxyTargetGroup private constructor(builder: Builder) {
    /**
     * The settings that determine the size and behavior of the connection pool for the target group.
     */
    public val connectionPoolConfig: aws.sdk.kotlin.services.rds.model.ConnectionPoolConfigurationInfo? = builder.connectionPoolConfig
    /**
     * The date and time when the target group was first created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The identifier for the RDS proxy associated with this target group.
     */
    public val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always `true`.
     */
    public val isDefault: kotlin.Boolean = builder.isDefault
    /**
     * The current status of this target group. A status of `available` means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn
    /**
     * The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.
     */
    public val targetGroupName: kotlin.String? = builder.targetGroupName
    /**
     * The date and time when the target group was last updated.
     */
    public val updatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedDate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbProxyTargetGroup(")
        append("connectionPoolConfig=$connectionPoolConfig,")
        append("createdDate=$createdDate,")
        append("dbProxyName=$dbProxyName,")
        append("isDefault=$isDefault,")
        append("status=$status,")
        append("targetGroupArn=$targetGroupArn,")
        append("targetGroupName=$targetGroupName,")
        append("updatedDate=$updatedDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionPoolConfig?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (isDefault.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (targetGroupName?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbProxyTargetGroup

        if (connectionPoolConfig != other.connectionPoolConfig) return false
        if (createdDate != other.createdDate) return false
        if (dbProxyName != other.dbProxyName) return false
        if (isDefault != other.isDefault) return false
        if (status != other.status) return false
        if (targetGroupArn != other.targetGroupArn) return false
        if (targetGroupName != other.targetGroupName) return false
        if (updatedDate != other.updatedDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The settings that determine the size and behavior of the connection pool for the target group.
         */
        public var connectionPoolConfig: aws.sdk.kotlin.services.rds.model.ConnectionPoolConfigurationInfo? = null
        /**
         * The date and time when the target group was first created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier for the RDS proxy associated with this target group.
         */
        public var dbProxyName: kotlin.String? = null
        /**
         * Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always `true`.
         */
        public var isDefault: kotlin.Boolean = false
        /**
         * The current status of this target group. A status of `available` means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.
         */
        public var status: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) representing the target group.
         */
        public var targetGroupArn: kotlin.String? = null
        /**
         * The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.
         */
        public var targetGroupName: kotlin.String? = null
        /**
         * The date and time when the target group was last updated.
         */
        public var updatedDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup) : this() {
            this.connectionPoolConfig = x.connectionPoolConfig
            this.createdDate = x.createdDate
            this.dbProxyName = x.dbProxyName
            this.isDefault = x.isDefault
            this.status = x.status
            this.targetGroupArn = x.targetGroupArn
            this.targetGroupName = x.targetGroupName
            this.updatedDate = x.updatedDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbProxyTargetGroup = DbProxyTargetGroup(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ConnectionPoolConfigurationInfo] inside the given [block]
         */
        public fun connectionPoolConfig(block: aws.sdk.kotlin.services.rds.model.ConnectionPoolConfigurationInfo.Builder.() -> kotlin.Unit) {
            this.connectionPoolConfig = aws.sdk.kotlin.services.rds.model.ConnectionPoolConfigurationInfo.invoke(block)
        }
    }
}
