// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB instance.
 */
public class DbInstanceRole private constructor(builder: Builder) {
    /**
     * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see `DBEngineVersion`.
     */
    public val featureName: kotlin.String? = builder.featureName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:
     * + `ACTIVE` - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.
     * + `PENDING` - the IAM role ARN is being associated with the DB instance.
     * + `INVALID` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbInstanceRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbInstanceRole(")
        append("featureName=$featureName,")
        append("roleArn=$roleArn,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = featureName?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbInstanceRole

        if (featureName != other.featureName) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbInstanceRole = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see `DBEngineVersion`.
         */
        public var featureName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:
         * + `ACTIVE` - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.
         * + `PENDING` - the IAM role ARN is being associated with the DB instance.
         * + `INVALID` - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbInstanceRole) : this() {
            this.featureName = x.featureName
            this.roleArn = x.roleArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbInstanceRole = DbInstanceRole(this)
    }
}
