// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details for an Amazon RDS DB cluster snapshot
 *
 * This data type is used as a response element in the `DescribeDBClusterSnapshots` action.
 */
public class DbClusterSnapshot private constructor(builder: Builder) {
    /**
     * Specifies the allocated storage size in gibibytes (GiB).
     */
    public val allocatedStorage: kotlin.Int = builder.allocatedStorage
    /**
     * Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.
     */
    public val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
     */
    public val clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.clusterCreateTime
    /**
     * Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The Amazon Resource Name (ARN) for the DB cluster snapshot.
     */
    public val dbClusterSnapshotArn: kotlin.String? = builder.dbClusterSnapshotArn
    /**
     * Specifies the identifier for the DB cluster snapshot.
     */
    public val dbClusterSnapshotIdentifier: kotlin.String? = builder.dbClusterSnapshotIdentifier
    /**
     * Reserved for future use.
     */
    public val dbSystemId: kotlin.String? = builder.dbSystemId
    /**
     * Specifies the name of the database engine for this DB cluster snapshot.
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * Provides the engine mode of the database engine for this DB cluster snapshot.
     */
    public val engineMode: kotlin.String? = builder.engineMode
    /**
     * Provides the version of the database engine for this DB cluster snapshot.
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
     */
    public val iamDatabaseAuthenticationEnabled: kotlin.Boolean = builder.iamDatabaseAuthenticationEnabled
    /**
     * If `StorageEncrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB cluster snapshot.
     *
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Provides the license model information for this DB cluster snapshot.
     */
    public val licenseModel: kotlin.String? = builder.licenseModel
    /**
     * Provides the master username for this DB cluster snapshot.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * Specifies the percentage of the estimated data that has been transferred.
     */
    public val percentProgress: kotlin.Int = builder.percentProgress
    /**
     * Specifies the port that the DB cluster was listening on at the time of the snapshot.
     */
    public val port: kotlin.Int = builder.port
    /**
     * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
     */
    public val snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.snapshotCreateTime
    /**
     * Provides the type of the DB cluster snapshot.
     */
    public val snapshotType: kotlin.String? = builder.snapshotType
    /**
     * If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.
     */
    public val sourceDbClusterSnapshotArn: kotlin.String? = builder.sourceDbClusterSnapshotArn
    /**
     * Specifies the status of this DB cluster snapshot. Valid statuses are the following:
     * + `available`
     * + `copying`
     * + `creating`
     */
    public val status: kotlin.String? = builder.status
    /**
     * Specifies whether the DB cluster snapshot is encrypted.
     */
    public val storageEncrypted: kotlin.Boolean = builder.storageEncrypted
    /**
     * The storage type associated with the DB cluster snapshot.
     *
     * This setting is only for Aurora DB clusters.
     */
    public val storageType: kotlin.String? = builder.storageType
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * Provides the VPC ID associated with the DB cluster snapshot.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbClusterSnapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbClusterSnapshot(")
        append("allocatedStorage=$allocatedStorage,")
        append("availabilityZones=$availabilityZones,")
        append("clusterCreateTime=$clusterCreateTime,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterSnapshotArn=$dbClusterSnapshotArn,")
        append("dbClusterSnapshotIdentifier=$dbClusterSnapshotIdentifier,")
        append("dbSystemId=$dbSystemId,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("iamDatabaseAuthenticationEnabled=$iamDatabaseAuthenticationEnabled,")
        append("kmsKeyId=$kmsKeyId,")
        append("licenseModel=$licenseModel,")
        append("masterUsername=$masterUsername,")
        append("percentProgress=$percentProgress,")
        append("port=$port,")
        append("snapshotCreateTime=$snapshotCreateTime,")
        append("snapshotType=$snapshotType,")
        append("sourceDbClusterSnapshotArn=$sourceDbClusterSnapshotArn,")
        append("status=$status,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tagList=$tagList,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (clusterCreateTime?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (dbClusterSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbSystemId?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (iamDatabaseAuthenticationEnabled.hashCode())
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (licenseModel?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (percentProgress)
        result = 31 * result + (port)
        result = 31 * result + (snapshotCreateTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotType?.hashCode() ?: 0)
        result = 31 * result + (sourceDbClusterSnapshotArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted.hashCode())
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbClusterSnapshot

        if (allocatedStorage != other.allocatedStorage) return false
        if (availabilityZones != other.availabilityZones) return false
        if (clusterCreateTime != other.clusterCreateTime) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterSnapshotArn != other.dbClusterSnapshotArn) return false
        if (dbClusterSnapshotIdentifier != other.dbClusterSnapshotIdentifier) return false
        if (dbSystemId != other.dbSystemId) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (iamDatabaseAuthenticationEnabled != other.iamDatabaseAuthenticationEnabled) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (licenseModel != other.licenseModel) return false
        if (masterUsername != other.masterUsername) return false
        if (percentProgress != other.percentProgress) return false
        if (port != other.port) return false
        if (snapshotCreateTime != other.snapshotCreateTime) return false
        if (snapshotType != other.snapshotType) return false
        if (sourceDbClusterSnapshotArn != other.sourceDbClusterSnapshotArn) return false
        if (status != other.status) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tagList != other.tagList) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbClusterSnapshot = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the allocated storage size in gibibytes (GiB).
         */
        public var allocatedStorage: kotlin.Int = 0
        /**
         * Provides the list of Availability Zones (AZs) where instances in the DB cluster snapshot can be restored.
         */
        public var availabilityZones: List<String>? = null
        /**
         * Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).
         */
        public var clusterCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the DB cluster identifier of the DB cluster that this DB cluster snapshot was created from.
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the DB cluster snapshot.
         */
        public var dbClusterSnapshotArn: kotlin.String? = null
        /**
         * Specifies the identifier for the DB cluster snapshot.
         */
        public var dbClusterSnapshotIdentifier: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        public var dbSystemId: kotlin.String? = null
        /**
         * Specifies the name of the database engine for this DB cluster snapshot.
         */
        public var engine: kotlin.String? = null
        /**
         * Provides the engine mode of the database engine for this DB cluster snapshot.
         */
        public var engineMode: kotlin.String? = null
        /**
         * Provides the version of the database engine for this DB cluster snapshot.
         */
        public var engineVersion: kotlin.String? = null
        /**
         * True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.
         */
        public var iamDatabaseAuthenticationEnabled: kotlin.Boolean = false
        /**
         * If `StorageEncrypted` is true, the Amazon Web Services KMS key identifier for the encrypted DB cluster snapshot.
         *
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Provides the license model information for this DB cluster snapshot.
         */
        public var licenseModel: kotlin.String? = null
        /**
         * Provides the master username for this DB cluster snapshot.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * Specifies the percentage of the estimated data that has been transferred.
         */
        public var percentProgress: kotlin.Int = 0
        /**
         * Specifies the port that the DB cluster was listening on at the time of the snapshot.
         */
        public var port: kotlin.Int = 0
        /**
         * Provides the time when the snapshot was taken, in Universal Coordinated Time (UTC).
         */
        public var snapshotCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the type of the DB cluster snapshot.
         */
        public var snapshotType: kotlin.String? = null
        /**
         * If the DB cluster snapshot was copied from a source DB cluster snapshot, the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise, a null value.
         */
        public var sourceDbClusterSnapshotArn: kotlin.String? = null
        /**
         * Specifies the status of this DB cluster snapshot. Valid statuses are the following:
         * + `available`
         * + `copying`
         * + `creating`
         */
        public var status: kotlin.String? = null
        /**
         * Specifies whether the DB cluster snapshot is encrypted.
         */
        public var storageEncrypted: kotlin.Boolean = false
        /**
         * The storage type associated with the DB cluster snapshot.
         *
         * This setting is only for Aurora DB clusters.
         */
        public var storageType: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * Provides the VPC ID associated with the DB cluster snapshot.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbClusterSnapshot) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.availabilityZones = x.availabilityZones
            this.clusterCreateTime = x.clusterCreateTime
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterSnapshotArn = x.dbClusterSnapshotArn
            this.dbClusterSnapshotIdentifier = x.dbClusterSnapshotIdentifier
            this.dbSystemId = x.dbSystemId
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.iamDatabaseAuthenticationEnabled = x.iamDatabaseAuthenticationEnabled
            this.kmsKeyId = x.kmsKeyId
            this.licenseModel = x.licenseModel
            this.masterUsername = x.masterUsername
            this.percentProgress = x.percentProgress
            this.port = x.port
            this.snapshotCreateTime = x.snapshotCreateTime
            this.snapshotType = x.snapshotType
            this.sourceDbClusterSnapshotArn = x.sourceDbClusterSnapshotArn
            this.status = x.status
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tagList = x.tagList
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbClusterSnapshot = DbClusterSnapshot(this)
    }
}
