// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class CreateEventSubscriptionRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A list of event categories for a particular source type (`SourceType`) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the *Amazon RDS User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html) or the *Amazon Aurora User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html). You can also see this list by using the `DescribeEventCategories` operation.
     */
    public val eventCategories: List<String>? = builder.eventCategories
    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn
    /**
     * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     *
     * Constraints:
     * + If `SourceIds` are supplied, `SourceType` must also be provided.
     * + If the source type is a DB instance, a `DBInstanceIdentifier` value must be supplied.
     * + If the source type is a DB cluster, a `DBClusterIdentifier` value must be supplied.
     * + If the source type is a DB parameter group, a `DBParameterGroupName` value must be supplied.
     * + If the source type is a DB security group, a `DBSecurityGroupName` value must be supplied.
     * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` value must be supplied.
     * + If the source type is a DB cluster snapshot, a `DBClusterSnapshotIdentifier` value must be supplied.
     * + If the source type is an RDS Proxy, a `DBProxyName` value must be supplied.
     */
    public val sourceIds: List<String>? = builder.sourceIds
    /**
     * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to `db-instance`. For RDS Proxy events, specify `db-proxy`. If this value isn't specified, all events are returned.
     *
     * Valid values: `db-instance` | `db-cluster` | `db-parameter-group` | `db-security-group` | `db-snapshot` | `db-cluster-snapshot` | `db-proxy`
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The name of the subscription.
     *
     * Constraints: The name must be less than 255 characters.
     */
    public val subscriptionName: kotlin.String? = builder.subscriptionName
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEventSubscriptionRequest(")
        append("enabled=$enabled,")
        append("eventCategories=$eventCategories,")
        append("snsTopicArn=$snsTopicArn,")
        append("sourceIds=$sourceIds,")
        append("sourceType=$sourceType,")
        append("subscriptionName=$subscriptionName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (eventCategories?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        result = 31 * result + (sourceIds?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subscriptionName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEventSubscriptionRequest

        if (enabled != other.enabled) return false
        if (eventCategories != other.eventCategories) return false
        if (snsTopicArn != other.snsTopicArn) return false
        if (sourceIds != other.sourceIds) return false
        if (sourceType != other.sourceType) return false
        if (subscriptionName != other.subscriptionName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A list of event categories for a particular source type (`SourceType`) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the *Amazon RDS User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html) or the *Amazon Aurora User Guide*[](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html). You can also see this list by using the `DescribeEventCategories` operation.
         */
        public var eventCategories: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         */
        public var snsTopicArn: kotlin.String? = null
        /**
         * The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
         *
         * Constraints:
         * + If `SourceIds` are supplied, `SourceType` must also be provided.
         * + If the source type is a DB instance, a `DBInstanceIdentifier` value must be supplied.
         * + If the source type is a DB cluster, a `DBClusterIdentifier` value must be supplied.
         * + If the source type is a DB parameter group, a `DBParameterGroupName` value must be supplied.
         * + If the source type is a DB security group, a `DBSecurityGroupName` value must be supplied.
         * + If the source type is a DB snapshot, a `DBSnapshotIdentifier` value must be supplied.
         * + If the source type is a DB cluster snapshot, a `DBClusterSnapshotIdentifier` value must be supplied.
         * + If the source type is an RDS Proxy, a `DBProxyName` value must be supplied.
         */
        public var sourceIds: List<String>? = null
        /**
         * The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to `db-instance`. For RDS Proxy events, specify `db-proxy`. If this value isn't specified, all events are returned.
         *
         * Valid values: `db-instance` | `db-cluster` | `db-parameter-group` | `db-security-group` | `db-snapshot` | `db-cluster-snapshot` | `db-proxy`
         */
        public var sourceType: kotlin.String? = null
        /**
         * The name of the subscription.
         *
         * Constraints: The name must be less than 255 characters.
         */
        public var subscriptionName: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionRequest) : this() {
            this.enabled = x.enabled
            this.eventCategories = x.eventCategories
            this.snsTopicArn = x.snsTopicArn
            this.sourceIds = x.sourceIds
            this.sourceType = x.sourceType
            this.subscriptionName = x.subscriptionName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(this)
    }
}
