// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
public class CreateDbSnapshotRequest private constructor(builder: Builder) {
    /**
     * The identifier of the DB instance that you want to create the snapshot of.
     *
     * Constraints:
     * + Must match the identifier of an existing DBInstance.
     */
    public val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The identifier for the DB snapshot.
     *
     * Constraints:
     * + Can't be null, empty, or blank
     * + Must contain from 1 to 255 letters, numbers, or hyphens
     * + First character must be a letter
     * + Can't end with a hyphen or contain two consecutive hyphens
     *
     * Example: `my-snapshot-id`
     */
    public val dbSnapshotIdentifier: kotlin.String? = builder.dbSnapshotIdentifier
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbSnapshotRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbSnapshotIdentifier=$dbSnapshotIdentifier,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbSnapshotRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbSnapshotIdentifier != other.dbSnapshotIdentifier) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbSnapshotRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the DB instance that you want to create the snapshot of.
         *
         * Constraints:
         * + Must match the identifier of an existing DBInstance.
         */
        public var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The identifier for the DB snapshot.
         *
         * Constraints:
         * + Can't be null, empty, or blank
         * + Must contain from 1 to 255 letters, numbers, or hyphens
         * + First character must be a letter
         * + Can't end with a hyphen or contain two consecutive hyphens
         *
         * Example: `my-snapshot-id`
         */
        public var dbSnapshotIdentifier: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbSnapshotRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbSnapshotIdentifier = x.dbSnapshotIdentifier
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbSnapshotRequest = CreateDbSnapshotRequest(this)
    }
}
