// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class CreateDbProxyEndpointRequest private constructor(builder: Builder) {
    /**
     * The name of the DB proxy endpoint to create.
     */
    public val dbProxyEndpointName: kotlin.String? = builder.dbProxyEndpointName
    /**
     * The name of the DB proxy associated with the DB proxy endpoint that you create.
     */
    public val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. The only role that proxies for RDS for Microsoft SQL Server support is `READ_WRITE`.
     */
    public val targetRole: aws.sdk.kotlin.services.rds.model.DbProxyEndpointTargetRole? = builder.targetRole
    /**
     * The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.
     */
    public val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.
     */
    public val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbProxyEndpointRequest(")
        append("dbProxyEndpointName=$dbProxyEndpointName,")
        append("dbProxyName=$dbProxyName,")
        append("tags=$tags,")
        append("targetRole=$targetRole,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbProxyEndpointName?.hashCode() ?: 0
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetRole?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbProxyEndpointRequest

        if (dbProxyEndpointName != other.dbProxyEndpointName) return false
        if (dbProxyName != other.dbProxyName) return false
        if (tags != other.tags) return false
        if (targetRole != other.targetRole) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the DB proxy endpoint to create.
         */
        public var dbProxyEndpointName: kotlin.String? = null
        /**
         * The name of the DB proxy associated with the DB proxy endpoint that you create.
         */
        public var dbProxyName: kotlin.String? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tags: List<Tag>? = null
        /**
         * A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. The only role that proxies for RDS for Microsoft SQL Server support is `READ_WRITE`.
         */
        public var targetRole: aws.sdk.kotlin.services.rds.model.DbProxyEndpointTargetRole? = null
        /**
         * The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.
         */
        public var vpcSecurityGroupIds: List<String>? = null
        /**
         * The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.
         */
        public var vpcSubnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointRequest) : this() {
            this.dbProxyEndpointName = x.dbProxyEndpointName
            this.dbProxyName = x.dbProxyName
            this.tags = x.tags
            this.targetRole = x.targetRole
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbProxyEndpointRequest = CreateDbProxyEndpointRequest(this)
    }
}
