// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



public class CreateBlueGreenDeploymentRequest private constructor(builder: Builder) {
    /**
     * The name of the blue/green deployment.
     *
     * Constraints:
     * + Can't be the same as an existing blue/green deployment name in the same account and Amazon Web Services Region.
     */
    public val blueGreenDeploymentName: kotlin.String? = builder.blueGreenDeploymentName
    /**
     * The Amazon Resource Name (ARN) of the source production database.
     *
     * Specify the database that you want to clone. The blue/green deployment creates this database in the green environment. You can make updates to the database in the green environment, such as an engine version upgrade. When you are ready, you can switch the database in the green environment to be the production database.
     */
    public val source: kotlin.String? = builder.source
    /**
     * Tags to assign to the blue/green deployment.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The DB cluster parameter group associated with the Aurora DB cluster in the green environment.
     *
     * To test parameter changes, specify a DB cluster parameter group that is different from the one associated with the source DB cluster.
     */
    public val targetDbClusterParameterGroupName: kotlin.String? = builder.targetDbClusterParameterGroupName
    /**
     * The DB parameter group associated with the DB instance in the green environment.
     *
     * To test parameter changes, specify a DB parameter group that is different from the one associated with the source DB instance.
     */
    public val targetDbParameterGroupName: kotlin.String? = builder.targetDbParameterGroupName
    /**
     * The engine version of the database in the green environment.
     *
     * Specify the engine version to upgrade to in the green environment.
     */
    public val targetEngineVersion: kotlin.String? = builder.targetEngineVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBlueGreenDeploymentRequest(")
        append("blueGreenDeploymentName=$blueGreenDeploymentName,")
        append("source=$source,")
        append("tags=$tags,")
        append("targetDbClusterParameterGroupName=$targetDbClusterParameterGroupName,")
        append("targetDbParameterGroupName=$targetDbParameterGroupName,")
        append("targetEngineVersion=$targetEngineVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blueGreenDeploymentName?.hashCode() ?: 0
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetDbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (targetDbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (targetEngineVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBlueGreenDeploymentRequest

        if (blueGreenDeploymentName != other.blueGreenDeploymentName) return false
        if (source != other.source) return false
        if (tags != other.tags) return false
        if (targetDbClusterParameterGroupName != other.targetDbClusterParameterGroupName) return false
        if (targetDbParameterGroupName != other.targetDbParameterGroupName) return false
        if (targetEngineVersion != other.targetEngineVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the blue/green deployment.
         *
         * Constraints:
         * + Can't be the same as an existing blue/green deployment name in the same account and Amazon Web Services Region.
         */
        public var blueGreenDeploymentName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source production database.
         *
         * Specify the database that you want to clone. The blue/green deployment creates this database in the green environment. You can make updates to the database in the green environment, such as an engine version upgrade. When you are ready, you can switch the database in the green environment to be the production database.
         */
        public var source: kotlin.String? = null
        /**
         * Tags to assign to the blue/green deployment.
         */
        public var tags: List<Tag>? = null
        /**
         * The DB cluster parameter group associated with the Aurora DB cluster in the green environment.
         *
         * To test parameter changes, specify a DB cluster parameter group that is different from the one associated with the source DB cluster.
         */
        public var targetDbClusterParameterGroupName: kotlin.String? = null
        /**
         * The DB parameter group associated with the DB instance in the green environment.
         *
         * To test parameter changes, specify a DB parameter group that is different from the one associated with the source DB instance.
         */
        public var targetDbParameterGroupName: kotlin.String? = null
        /**
         * The engine version of the database in the green environment.
         *
         * Specify the engine version to upgrade to in the green environment.
         */
        public var targetEngineVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentRequest) : this() {
            this.blueGreenDeploymentName = x.blueGreenDeploymentName
            this.source = x.source
            this.tags = x.tags
            this.targetDbClusterParameterGroupName = x.targetDbClusterParameterGroupName
            this.targetDbParameterGroupName = x.targetDbParameterGroupName
            this.targetEngineVersion = x.targetEngineVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateBlueGreenDeploymentRequest = CreateBlueGreenDeploymentRequest(this)
    }
}
