// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details about a task for a blue/green deployment.
 *
 * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [ Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
 */
public class BlueGreenDeploymentTask private constructor(builder: Builder) {
    /**
     * The name of the blue/green deployment task.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of the blue/green deployment task.
     *
     * Values:
     * + `PENDING` - The resources are being prepared for deployment.
     * + `IN_PROGRESS` - The resource is being deployed.
     * + `COMPLETED` - The resource has been deployed.
     * + `FAILED` - Deployment of the resource failed.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.BlueGreenDeploymentTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlueGreenDeploymentTask(")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlueGreenDeploymentTask

        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.BlueGreenDeploymentTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the blue/green deployment task.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the blue/green deployment task.
         *
         * Values:
         * + `PENDING` - The resources are being prepared for deployment.
         * + `IN_PROGRESS` - The resource is being deployed.
         * + `COMPLETED` - The resource has been deployed.
         * + `FAILED` - Deployment of the resource failed.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.BlueGreenDeploymentTask) : this() {
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.BlueGreenDeploymentTask = BlueGreenDeploymentTask(this)
    }
}
