// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details about a blue/green deployment.
 *
 * For more information, see [Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html) in the *Amazon RDS User Guide* and [ Using Amazon RDS Blue/Green Deployments for database updates](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html) in the *Amazon Aurora User Guide*.
 */
public class BlueGreenDeployment private constructor(builder: Builder) {
    /**
     * The system-generated identifier of the blue/green deployment.
     */
    public val blueGreenDeploymentIdentifier: kotlin.String? = builder.blueGreenDeploymentIdentifier
    /**
     * The user-supplied name of the blue/green deployment.
     */
    public val blueGreenDeploymentName: kotlin.String? = builder.blueGreenDeploymentName
    /**
     * Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
     */
    public val deleteTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deleteTime
    /**
     * The source database for the blue/green deployment.
     *
     * Before switchover, the source database is the production database in the blue environment.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The status of the blue/green deployment.
     *
     * Values:
     * + `PROVISIONING` - Resources are being created in the green environment.
     * + `AVAILABLE` - Resources are available in the green environment.
     * + `SWITCHOVER_IN_PROGRESS` - The deployment is being switched from the blue environment to the green environment.
     * + `SWITCHOVER_COMPLETED` - Switchover from the blue environment to the green environment is complete.
     * + `INVALID_CONFIGURATION` - Resources in the green environment are invalid, so switchover isn't possible.
     * + `SWITCHOVER_FAILED` - Switchover was attempted but failed.
     * + `DELETING` - The blue/green deployment is being deleted.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Additional information about the status of the blue/green deployment.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The details about each source and target resource in the blue/green deployment.
     */
    public val switchoverDetails: List<SwitchoverDetail>? = builder.switchoverDetails
    /**
     * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
     */
    public val tagList: List<Tag>? = builder.tagList
    /**
     * The target database for the blue/green deployment.
     *
     * Before switchover, the target database is the clone database in the green environment.
     */
    public val target: kotlin.String? = builder.target
    /**
     * Either tasks to be performed or tasks that have been completed on the target database before switchover.
     */
    public val tasks: List<BlueGreenDeploymentTask>? = builder.tasks

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.BlueGreenDeployment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlueGreenDeployment(")
        append("blueGreenDeploymentIdentifier=$blueGreenDeploymentIdentifier,")
        append("blueGreenDeploymentName=$blueGreenDeploymentName,")
        append("createTime=$createTime,")
        append("deleteTime=$deleteTime,")
        append("source=$source,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("switchoverDetails=$switchoverDetails,")
        append("tagList=$tagList,")
        append("target=$target,")
        append("tasks=$tasks")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blueGreenDeploymentIdentifier?.hashCode() ?: 0
        result = 31 * result + (blueGreenDeploymentName?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (deleteTime?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (switchoverDetails?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (tasks?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlueGreenDeployment

        if (blueGreenDeploymentIdentifier != other.blueGreenDeploymentIdentifier) return false
        if (blueGreenDeploymentName != other.blueGreenDeploymentName) return false
        if (createTime != other.createTime) return false
        if (deleteTime != other.deleteTime) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (switchoverDetails != other.switchoverDetails) return false
        if (tagList != other.tagList) return false
        if (target != other.target) return false
        if (tasks != other.tasks) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.BlueGreenDeployment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The system-generated identifier of the blue/green deployment.
         */
        public var blueGreenDeploymentIdentifier: kotlin.String? = null
        /**
         * The user-supplied name of the blue/green deployment.
         */
        public var blueGreenDeploymentName: kotlin.String? = null
        /**
         * Specifies the time when the blue/green deployment was created, in Universal Coordinated Time (UTC).
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time when the blue/green deployment was deleted, in Universal Coordinated Time (UTC).
         */
        public var deleteTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The source database for the blue/green deployment.
         *
         * Before switchover, the source database is the production database in the blue environment.
         */
        public var source: kotlin.String? = null
        /**
         * The status of the blue/green deployment.
         *
         * Values:
         * + `PROVISIONING` - Resources are being created in the green environment.
         * + `AVAILABLE` - Resources are available in the green environment.
         * + `SWITCHOVER_IN_PROGRESS` - The deployment is being switched from the blue environment to the green environment.
         * + `SWITCHOVER_COMPLETED` - Switchover from the blue environment to the green environment is complete.
         * + `INVALID_CONFIGURATION` - Resources in the green environment are invalid, so switchover isn't possible.
         * + `SWITCHOVER_FAILED` - Switchover was attempted but failed.
         * + `DELETING` - The blue/green deployment is being deleted.
         */
        public var status: kotlin.String? = null
        /**
         * Additional information about the status of the blue/green deployment.
         */
        public var statusDetails: kotlin.String? = null
        /**
         * The details about each source and target resource in the blue/green deployment.
         */
        public var switchoverDetails: List<SwitchoverDetail>? = null
        /**
         * A list of tags. For more information, see [Tagging Amazon RDS Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html) in the *Amazon RDS User Guide.*
         */
        public var tagList: List<Tag>? = null
        /**
         * The target database for the blue/green deployment.
         *
         * Before switchover, the target database is the clone database in the green environment.
         */
        public var target: kotlin.String? = null
        /**
         * Either tasks to be performed or tasks that have been completed on the target database before switchover.
         */
        public var tasks: List<BlueGreenDeploymentTask>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.BlueGreenDeployment) : this() {
            this.blueGreenDeploymentIdentifier = x.blueGreenDeploymentIdentifier
            this.blueGreenDeploymentName = x.blueGreenDeploymentName
            this.createTime = x.createTime
            this.deleteTime = x.deleteTime
            this.source = x.source
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.switchoverDetails = x.switchoverDetails
            this.tagList = x.tagList
            this.target = x.target
            this.tasks = x.tasks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.BlueGreenDeployment = BlueGreenDeployment(this)
    }
}
