// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 *
 */
public class BacktrackDbClusterRequest private constructor(builder: Builder) {
    /**
     * The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
     *
     * If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.
     *
     * Constraints:
     * + Must contain a valid ISO 8601 timestamp.
     * + Can't contain a timestamp set in the future.
     *
     * Example: `2017-07-08T18:00Z`
     */
    public val backtrackTo: aws.smithy.kotlin.runtime.time.Instant? = builder.backtrackTo
    /**
     * The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.
     *
     * Constraints:
     * + Must contain from 1 to 63 alphanumeric characters or hyphens.
     * + First character must be a letter.
     * + Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Example: `my-cluster1`
     */
    public val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.
     */
    public val force: kotlin.Boolean? = builder.force
    /**
     * A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time, an error occurs.
     */
    public val useEarliestTimeOnPointInTimeUnavailable: kotlin.Boolean? = builder.useEarliestTimeOnPointInTimeUnavailable

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BacktrackDbClusterRequest(")
        append("backtrackTo=$backtrackTo,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("force=$force,")
        append("useEarliestTimeOnPointInTimeUnavailable=$useEarliestTimeOnPointInTimeUnavailable")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backtrackTo?.hashCode() ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (force?.hashCode() ?: 0)
        result = 31 * result + (useEarliestTimeOnPointInTimeUnavailable?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BacktrackDbClusterRequest

        if (backtrackTo != other.backtrackTo) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (force != other.force) return false
        if (useEarliestTimeOnPointInTimeUnavailable != other.useEarliestTimeOnPointInTimeUnavailable) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the [ISO8601 Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
         *
         * If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.
         *
         * Constraints:
         * + Must contain a valid ISO 8601 timestamp.
         * + Can't contain a timestamp set in the future.
         *
         * Example: `2017-07-08T18:00Z`
         */
        public var backtrackTo: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.
         *
         * Constraints:
         * + Must contain from 1 to 63 alphanumeric characters or hyphens.
         * + First character must be a letter.
         * + Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Example: `my-cluster1`
         */
        public var dbClusterIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.
         */
        public var force: kotlin.Boolean? = null
        /**
         * A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and *BacktrackTo* is set to a timestamp earlier than the earliest backtrack time, an error occurs.
         */
        public var useEarliestTimeOnPointInTimeUnavailable: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.BacktrackDbClusterRequest) : this() {
            this.backtrackTo = x.backtrackTo
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.force = x.force
            this.useEarliestTimeOnPointInTimeUnavailable = x.useEarliestTimeOnPointInTimeUnavailable
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.BacktrackDbClusterRequest = BacktrackDbClusterRequest(this)
    }
}
