// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rbin

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rbin.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.rbin.model.*
import aws.sdk.kotlin.services.rbin.model.CreateRuleRequest
import aws.sdk.kotlin.services.rbin.model.CreateRuleResponse
import aws.sdk.kotlin.services.rbin.model.DeleteRuleRequest
import aws.sdk.kotlin.services.rbin.model.DeleteRuleResponse
import aws.sdk.kotlin.services.rbin.model.GetRuleRequest
import aws.sdk.kotlin.services.rbin.model.GetRuleResponse
import aws.sdk.kotlin.services.rbin.model.ListRulesRequest
import aws.sdk.kotlin.services.rbin.model.ListRulesResponse
import aws.sdk.kotlin.services.rbin.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.rbin.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.rbin.model.TagResourceRequest
import aws.sdk.kotlin.services.rbin.model.TagResourceResponse
import aws.sdk.kotlin.services.rbin.model.UntagResourceRequest
import aws.sdk.kotlin.services.rbin.model.UntagResourceResponse
import aws.sdk.kotlin.services.rbin.model.UpdateRuleRequest
import aws.sdk.kotlin.services.rbin.model.UpdateRuleResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the *Recycle Bin API Reference*. This documentation provides descriptions and syntax for each of the actions and data types in Recycle Bin.
 *
 * Recycle Bin is a resource recovery feature that enables you to restore accidentally deleted snapshots and EBS-backed AMIs. When using Recycle Bin, if your resources are deleted, they are retained in the Recycle Bin for a time period that you specify.
 *
 * You can restore a resource from the Recycle Bin at any time before its retention period expires. After you restore a resource from the Recycle Bin, the resource is removed from the Recycle Bin, and you can then use it in the same way you use any other resource of that type in your account. If the retention period expires and the resource is not restored, the resource is permanently deleted from the Recycle Bin and is no longer available for recovery. For more information about Recycle Bin, see [ Recycle Bin](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-recycle-bin.html) in the *Amazon Elastic Compute Cloud User Guide*.
 */
public interface RbinClient : SdkClient {

    override val serviceName: String
        get() = "rbin"
    /**
     * RbinClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): RbinClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRbinClient(config)
        }

        public operator fun invoke(config: Config): RbinClient = DefaultRbinClient(config)

        /**
         * Construct a [RbinClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RbinClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultRbinClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Recycle Bin retention rule. For more information, see [ Create Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * Deletes a Recycle Bin retention rule. For more information, see [ Delete Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Gets information about a Recycle Bin retention rule.
     */
    public suspend fun getRule(input: GetRuleRequest): GetRuleResponse

    /**
     * Lists the Recycle Bin retention rules in the Region.
     */
    public suspend fun listRules(input: ListRulesRequest): ListRulesResponse

    /**
     * Lists the tags assigned to a retention rule.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Assigns tags to the specified retention rule.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Unassigns a tag from a retention rule.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Recycle Bin retention rule. For more information, see [ Update Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public suspend fun updateRule(input: UpdateRuleRequest): UpdateRuleResponse
}

/**
 * Creates a Recycle Bin retention rule. For more information, see [ Create Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-create-rule) in the *Amazon Elastic Compute Cloud User Guide*.
 */
public suspend inline fun RbinClient.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * Deletes a Recycle Bin retention rule. For more information, see [ Delete Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-delete-rule) in the *Amazon Elastic Compute Cloud User Guide*.
 */
public suspend inline fun RbinClient.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Gets information about a Recycle Bin retention rule.
 */
public suspend inline fun RbinClient.getRule(crossinline block: GetRuleRequest.Builder.() -> Unit): GetRuleResponse = getRule(GetRuleRequest.Builder().apply(block).build())

/**
 * Lists the Recycle Bin retention rules in the Region.
 */
public suspend inline fun RbinClient.listRules(crossinline block: ListRulesRequest.Builder.() -> Unit): ListRulesResponse = listRules(ListRulesRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a retention rule.
 */
public suspend inline fun RbinClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Assigns tags to the specified retention rule.
 */
public suspend inline fun RbinClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Unassigns a tag from a retention rule.
 */
public suspend inline fun RbinClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Recycle Bin retention rule. For more information, see [ Update Recycle Bin retention rules](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/recycle-bin-working-with-rules.html#recycle-bin-update-rule) in the *Amazon Elastic Compute Cloud User Guide*.
 */
public suspend inline fun RbinClient.updateRule(crossinline block: UpdateRuleRequest.Builder.() -> Unit): UpdateRuleResponse = updateRule(UpdateRuleRequest.Builder().apply(block).build())
