// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.serde

import aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest
import aws.sdk.kotlin.services.quicksight.model.UserRole
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateUserOperationSerializer: HttpSerializer.NonStreaming<UpdateUserRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.awsAccountId) { "awsAccountId is bound to the URI and must not be null" }
            requireNotNull(input.namespace) { "namespace is bound to the URI and must not be null" }
            requireNotNull(input.userName) { "userName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("accounts"))
                add(PercentEncoding.SmithyLabel.encode(input.awsAccountId))
                add(PercentEncoding.Path.encode("namespaces"))
                add(PercentEncoding.SmithyLabel.encode(input.namespace))
                add(PercentEncoding.Path.encode("users"))
                add(PercentEncoding.SmithyLabel.encode(input.userName))
            }
        }

        val payload = serializeUpdateUserOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateUserOperationBody(context: ExecutionContext, input: UpdateUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomFederationProviderUrl"))
    val CUSTOMPERMISSIONSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomPermissionsName"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExternalLoginFederationProviderType"))
    val EXTERNALLOGINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExternalLoginId"))
    val ROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Role"))
    val UNAPPLYCUSTOMPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("UnapplyCustomPermissions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR)
        field(CUSTOMPERMISSIONSNAME_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR)
        field(EXTERNALLOGINID_DESCRIPTOR)
        field(ROLE_DESCRIPTOR)
        field(UNAPPLYCUSTOMPERMISSIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.customFederationProviderUrl?.let { field(CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR, it) }
        input.customPermissionsName?.let { field(CUSTOMPERMISSIONSNAME_DESCRIPTOR, it) }
        input.email?.let { field(EMAIL_DESCRIPTOR, it) }
        input.externalLoginFederationProviderType?.let { field(EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR, it) }
        input.externalLoginId?.let { field(EXTERNALLOGINID_DESCRIPTOR, it) }
        input.role?.let { field(ROLE_DESCRIPTOR, it.value) }
        input.unapplyCustomPermissions?.let { field(UNAPPLYCUSTOMPERMISSIONS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
